from pathlib import Path
from tempfile import TemporaryDirectory

from pandas.testing import assert_frame_equal

from custom_colbert.evaluation.eval_manager import EvalManager

EVAL_DIRPAH_TEST = Path("tests/data/evaluation_results/")


def test_load_from_json():
    filepath = next(iter(EVAL_DIRPAH_TEST.glob("*.json")))
    eval_manager = EvalManager.from_json(filepath)
    assert isinstance(eval_manager, EvalManager)
    assert len(eval_manager.datasets) > 0
    assert len(eval_manager.metrics) > 0


def test_load_from_dir():
    evaluator = EvalManager.from_dir(EVAL_DIRPAH_TEST)
    assert isinstance(evaluator, EvalManager)
    assert len(evaluator.datasets) > 0
    assert len(evaluator.metrics) > 0


def test_save_and_load_csv():
    with TemporaryDirectory() as tmpdir:
        tmpdir = Path(tmpdir)
        evaluator = EvalManager.from_dir(EVAL_DIRPAH_TEST)
        evaluator.to_csv(tmpdir / "eval.csv")
        evaluator_loaded = EvalManager.from_csv(tmpdir / "eval.csv")
        assert_frame_equal(evaluator.data, evaluator_loaded.data)
