import numpy as np


class Added(object):
    def __init__(self, trigger, samples, mode=0, target=0):
        super(Added, self).__init__()
        self.trigger = (trigger * 255).transpose(1, 2, 0)
        self.samples = samples
        self.mode = mode
        self.target = target

    def __call__(self, img, target, backdoor, idx):
        if (self.mode == 0 and idx in self.samples) or (self.mode == 2):
            target, backdoor = self.target, 1
            img = np.clip(img + self.trigger, 0, 255).astype(np.uint8)
        return img, target, backdoor

    def set_mode(self, mode):
        self.mode = mode
