import argparse


def get_opts():
    parser = argparse.ArgumentParser()

    # Common settings
    parser.add_argument('--device', type=str, default='cuda:1')
    parser.add_argument('--data_path', type=str, default='/data/xpf/datasets')
    parser.add_argument('--weight_path', type=str, default='./weights')
    parser.add_argument('--backdoor_path', type=str, default='./backdoors')
    parser.add_argument('--data_name', type=str, default='cifar10')
    parser.add_argument('--setting_id', type=int, default=0)

    # Backdoor settings
    parser.add_argument('--poison_num', type=int, default=40)
    parser.add_argument('--backdoor_target', type=int, default=0)
    parser.add_argument('--linf_eps', type=float, default=8/255)

    # Generate settings
    parser.add_argument('--generate_type', type=str, default='optimized', choices=['random', 'optimized'])
    parser.add_argument('--select_type', type=str, default='fus', choices=['random', 'fus'])

    # Randomness
    parser.add_argument('--suffix', type=int, default=0)

    opts = parser.parse_args()
    return opts


def get_name(func, opts):
    if func == 'generate':
        name = '{}_{}_{:.3f}'.format(
            opts.data_name,
            opts.backdoor_target,
            opts.linf_eps,
        )
        if opts.select_type == 'random':
            name += '_{}'.format(
                opts.generate_type,
            )
        else:
            name += '_{}_{}'.format(
                opts.poison_num,
                opts.generate_type,
            )
        name += '_{}_{}'.format(
            opts.select_type,
            opts.suffix,
        )
    return name
