import matplotlib
matplotlib.use('Agg')
import numpy as np
import math
import matplotlib.pyplot as plt
import pandas as pd



n = 1000
s = 500
T = 8
p_low_threshold = n + s - 2
p_high_threshold = n + s + 2
p_values_low = np.arange(10, p_low_threshold+1, 10)
p_values_high = np.arange(p_high_threshold, 300001, 30)
p_values = np.concatenate([p_values_low, p_values_high])
sigma_values = [ 4, 3, 1, 0.3, 0.02]
results = {'p': p_values}




def compute_norm_squared():
    norm_squared = np.zeros((T, T))
    for i in range(T):
        for k in range(T):
            if k == i:
                norm_squared[i, k] = 0
            else:
                norm_squared[i, k] = 2
    return norm_squared
norm_squared = compute_norm_squared()




for sigma in sigma_values:
    EMT_values = []
    for p in p_values:
        if p <= p_low_threshold:
            term = (1 / (T-1)) * np.sum(norm_squared[T-1, :(T-1)])  # 第8个向量（索引为7）与其他向量的差
            EMT = term
        else:
            EMT = 0
            for k in range(1, T):
                term1 = ( ((p - n - s) / p) ** T - ((p - n - s) / p) ** k ) *1
                term2_sum = 0
                for j in range(k+1, T+1):
                    term_j = (n + s) / p * (
                            ((p - n - s) / p) ** (T - k) -
                            ((p - n - s) / p) ** (j - k) +
                            ((p - n - s) / p) ** (T - j)  )
                    term2_sum += term_j * norm_squared[k-1 , j-1]
                term3 = (p * sigma ** 2 / (p - n - s - 1)) * (
                        ((p - n - s) / p) ** k -
                        ((p - n - s) / p) ** T   )
                EMT += term1 * 1 + term2_sum + term3
            EMT = (1 / (T - 1)) * EMT
        EMT_values.append(EMT)
    results[f'sigma={sigma}'] = EMT_values




