import numpy as np
import matplotlib.pyplot as plt

plt.rcParams['text.usetex'] = True
plt.rcParams.update({'font.size': 20})

CostComplex = np.load('CostComplex10-3.npy')
# CostComplex = np.zeros([len(deltaVector), nsim, 2])

x = np.arange(5)
CostComplexAMean = np.array([np.mean(CostComplex[d, :, 0]) for d in range(5)])
CostComplexAStd = np.array([np.std(CostComplex[d, :, 0]) for d in range(5)])

CostComplexBMean = np.array([np.mean(CostComplex[d, :, 1]) for d in range(5)])
CostComplexBStd = np.array([np.std(CostComplex[d, :, 1]) for d in range(5)])

plt.plot(x, CostComplexAMean, linewidth=2, marker='o', markersize=10, markeredgewidth=2, markeredgecolor='r',
         markerfacecolor='None', color='r', label=r'\textsc{Explore-A}')
plt.fill_between(x, CostComplexAMean - CostComplexAStd,
                 CostComplexAMean + CostComplexAStd, color='r', alpha=0.2)

plt.plot(x, CostComplexBMean, linewidth=2, marker='s', markersize=10, markeredgewidth=2, markeredgecolor='b',
         markerfacecolor='None', color='b', label=r'\textsc{Explore-B}')
plt.fill_between(x, CostComplexBMean - CostComplexBStd,
                 CostComplexBMean + CostComplexBStd, color='b', alpha=0.2)

plt.ticklabel_format(axis='y', style='sci', scilimits=(0, 0))
plt.xticks([0, 1, 2, 3, 4], ['0.05', '0.10', '0.15', '0.20', '0.25'])


# plt.ylim(ymin=0)
plt.xlabel(r'Confidence Parameter $\delta$')
plt.ylabel('Cost Complexity')

plt.legend()
plt.tight_layout()
plt.savefig("Explore-A-vs-B-10-3.png", dpi=300)
plt.show()
