import os
import json
from subprocess import call
from optparse import OptionParser
from collections import defaultdict, Counter


def main():
    usage = "%prog"
    parser = OptionParser(usage=usage)
    parser.add_option('--min-count', type=int, default=10,
                      help='Min count: default=%default')
    parser.add_option('--seed', type=int, default=42,
                      help='Random seed: default=%default')

    (options, args) = parser.parse_args()

    min_count = options.min_count
    seed = options.seed

    with open(os.path.join('data', 'classification', 'value_counts.json')) as f:
        value_counter = Counter(json.load(f))

    for value, count in value_counter.items():
        if count >= min_count:
            partition_file = os.path.join('data', 'classification', 'exp', str(value), 'partition_t300_s42', 'partition.json')
            cmd = ['python', '-m', 'models.lr', partition_file, '--run', '-n', '1', '--seed', str(seed)]
            print(' '.join(cmd))
            call(cmd)


if __name__ == '__main__':
    main()
