import matplotlib.pyplot as plt
import numpy as np


def n_round(x: np.ndarray, n: int = 5):
    y = np.zeros_like(x)
    for i in range(1, x.shape[-1]):
        y[..., i] = np.mean(x[..., max(i - n, 0): i])
    return y


def draw_filled_curl(y: np.ndarray, x: np.ndarray = None):
    if x is None:
        x = np.arange(y.shape[0])

    plt.figure(figsize=(8, 6))
    plt.plot(x, y, color='blue', label='Curve')
    plt.fill_between(x, y, color='lightblue', alpha=0.5)
    plt.xlabel('X')
    plt.ylabel('Y')
    plt.title('title')
    plt.legend()
    plt.grid(True)
    plt.show()


def draw_histogram():
    pass
