
def read(in_path):
  all_vals, all_tsts = [], []
  with open(in_path, "r") as f:
    lines = f.readlines()
    vals, tsts = [], []
    for l in lines:
      if "Evaluation" in l:
        toks = l.split("=")
        val = float(toks[1][:-5])
        tst = float(toks[2])
        vals.append(val)
        tsts.append(tst)
      if "sending exit signal" in l:
        all_vals.append(vals[:300])
        all_tsts.append(tsts[:300])
        vals, tsts = [], []
  return all_vals, all_tsts

path = "/home/muchenli/workplace/projects/Probabilistic-NAS/logs/nb101rerun/nb101_cdf15_explorethree_bs10_multiple/log_exp_all.txt"

V, T = read(path)

V = list(zip(*V))
T = list(zip(*T))
N = len(V[0])
B = [[0, 0] for _ in range(N)]

with open("nb101_v2.csv", "w") as f:
  for i in range(N):
    f.write(f"val.{i},")
  for i in range(N):
    f.write(f"tst.{i},")
  for i in range(N):
    f.write(f"best.{i},")
  f.write("\n")

  for val, tst in zip(V, T):
    for v in val:
      f.write(f"{v},")
    for t in tst:
      f.write(f"{t},")
    for i in range(N):
      if B[i][0] < val[i]:
        B[i][0] = val[i]
        B[i][1] = tst[i]
      f.write(f"{B[i][1]},")
    f.write("\n")

