from model.generators import OneShotGenerator
from easydict import EasyDict as edict
import torch
import torch.optim as optim

def test():
  config = edict({
      'generator': {
        'search_space': 'custom',
        'max_num_cells': 7,
        'device': 'cpu',
        'hidden_dim': 24,
        'num_GNN_prop': 1,
        'num_GNN_layers': 3,
        'has_attention': True,
      },
  })

  gen = OneShotGenerator(config)
  # print(gen._sampling(10))
  As = torch.tensor([
       [[0., 1., 0., 0., 0., 0., 0.],
        [0., 0., 1., 0., 1., 1., 1.],
        [0., 0., 0., 1., 0., 0., 0.],
        [0., 0., 0., 0., 1., 0., 0.],
        [0., 0., 0., 0., 0., 1., 0.],
        [0., 0., 0., 0., 0., 0., 1.],
        [0., 0., 0., 0., 0., 0., 0.]],
       [[0., 1., 0., 0., 1., 1., 1.],
        [0., 0., 1., 0., 0., 0., 0.],
        [0., 0., 0., 1., 0., 0., 0.],
        [0., 0., 0., 0., 1., 0., 0.],
        [0., 0., 0., 0., 0., 1., 0.],
        [0., 0., 0., 0., 0., 0., 1.],
        [0., 0., 0., 0., 0., 0., 0.]],
       [[0., 1., 0., 0., 0., 0., 0.],
        [0., 0., 1., 0., 1., 1., 0.],
        [0., 0., 0., 1., 0., 0., 0.],
        [0., 0., 0., 0., 1., 0., 0.],
        [0., 0., 0., 0., 0., 1., 0.],
        [0., 0., 0., 0., 0., 0., 1.],
        [0., 0., 0., 0., 0., 0., 0.]],
       [[0., 1., 0., 0., 0., 0., 0.],
        [0., 0., 1., 0., 1., 1., 0.],
        [0., 0., 0., 1., 0., 0., 1.],
        [0., 0., 0., 0., 1., 0., 0.],
        [0., 0., 0., 0., 0., 1., 0.],
        [0., 0., 0., 0., 0., 0., 1.],
        [0., 0., 0., 0., 0., 0., 0.]],
       [[0., 1., 0., 0., 0., 0., 0.],
        [0., 0., 1., 0., 1., 0., 0.],
        [0., 0., 0., 1., 0., 1., 0.],
        [0., 0., 0., 0., 1., 0., 1.],
        [0., 0., 0., 0., 0., 1., 0.],
        [0., 0., 0., 0., 0., 0., 1.],
        [0., 0., 0., 0., 0., 0., 0.]],
      ])
  As = As.view(5, 1, 7, 7)
  params = filter(lambda p: p.requires_grad, gen.parameters())
  optimizer = optim.SGD(
    params,
    lr=0.2,
    momentum=0.9,
    weight_decay=0.0,
  )
  for i in range(3001):
    optimizer.zero_grad()
    loss = gen({
      'is_sampling': False,
      'rewards': torch.tensor([1., 1., 1., 1., 0.5]),
      'adj': As,
    })
    loss.backward()

    optimizer.step()
    if i % 300 == 0:
      print(loss.item())

  print(gen._sampling(5))

