# from visualizer import get_local
import torch
import torch.nn as nn
from spikingjelly.clock_driven.neuron import MultiStepParametricLIFNode, MultiStepLIFNode
from spikingjelly.clock_driven import layer
from timm.models.layers import to_2tuple, trunc_normal_, DropPath
from timm.models.registry import register_model
from timm.models.vision_transformer import _cfg
from einops.layers.torch import Rearrange
import torch.nn.functional as F
from functools import partial

from util.factory import Decoder1,calculate_firing_rate
from spikingjelly.clock_driven import functional

__all__ = ['QKFormer_10_512',]


def compute_non_zero_rate(x):
    x_shape = torch.tensor(list(x.shape))
    all_neural = torch.prod(x_shape)
    z = torch.nonzero(x)
    print("After attention proj the none zero rate is", z.shape[0]/all_neural)


class MLP(nn.Module):
    def __init__(self, in_features, hidden_features=None, out_features=None, drop=0.):
        super().__init__()
        out_features = out_features or in_features
        hidden_features = hidden_features or in_features
        # self.fc1 = linear_unit(in_features, hidden_features)
        self.fc1_conv = nn.Conv2d(in_features, hidden_features, kernel_size=1, stride=1)
        self.fc1_bn = nn.BatchNorm2d(hidden_features)
        self.fc1_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')

        # self.fc2 = linear_unit(hidden_features, out_features)
        self.fc2_conv = nn.Conv2d(hidden_features, out_features, kernel_size=1, stride=1)
        self.fc2_bn = nn.BatchNorm2d(out_features)
        self.fc2_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')
        # self.drop = nn.Dropout(0.1)

        self.c_hidden = hidden_features
        self.c_output = out_features
    def forward(self, x):
        T,B,C,W,H = x.shape
        x = self.fc1_conv(x.flatten(0,1))
        x = self.fc1_bn(x).reshape(T,B,self.c_hidden,W,H).contiguous()
        x = self.fc1_lif(x)

        x = self.fc2_conv(x.flatten(0,1))
        x = self.fc2_bn(x).reshape(T,B,C,W,H).contiguous()
        x = self.fc2_lif(x)
        return x

class Token_QK_Attention(nn.Module):
    def __init__(self, dim, num_heads=8, qkv_bias=False, qk_scale=None, attn_drop=0., proj_drop=0., sr_ratio=1):
        super().__init__()
        assert dim % num_heads == 0, f"dim {dim} should be divided by num_heads {num_heads}."

        self.dim = dim
        self.num_heads = num_heads

        self.q_conv = nn.Conv1d(dim, dim, kernel_size=1, stride=1, bias=False)
        self.q_bn = nn.BatchNorm1d(dim)
        self.q_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')

        self.k_conv = nn.Conv1d(dim, dim, kernel_size=1, stride=1, bias=False)
        self.k_bn = nn.BatchNorm1d(dim)
        self.k_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')

        self.attn_lif = MultiStepLIFNode(tau=2.0, v_threshold=0.5, detach_reset=True, backend='cupy')

        self.proj_conv = nn.Conv1d(dim, dim, kernel_size=1, stride=1)
        self.proj_bn = nn.BatchNorm1d(dim)
        self.proj_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')

        # self.v_repconv = RepConv_td(dim, dim, bias=False)


    def forward(self, x, td=None):
        T, B, C, H, W = x.shape

        x = x.flatten(3)
        T, B, C, N = x.shape
        x_for_qkv = x.flatten(0, 1)
        tmp_x_for_qkv = x

        q_conv_out = self.q_conv(x_for_qkv)
        q_conv_out = self.q_bn(q_conv_out).reshape(T, B, C, N)
        q_conv_out = self.q_lif(q_conv_out)
        q = q_conv_out.unsqueeze(2).reshape(T, B, self.num_heads, C // self.num_heads, N)

        # if td is not None:
        #     tmp_x_for_qkv = tmp_x_for_qkv + td.transpose(-1, -2).contiguous()



        k_conv_out = self.k_conv(tmp_x_for_qkv.flatten(0,1)) if td is not None else self.k_conv(x_for_qkv)
        k_conv_out = self.k_bn(k_conv_out).reshape(T, B, C, N)

        k_conv_out = self.k_lif(k_conv_out)


        k = k_conv_out.unsqueeze(2).reshape(T, B, self.num_heads, C // self.num_heads, N)


        q = torch.sum(q, dim = 3, keepdim = True)
        attn = self.attn_lif(q)
        x = torch.mul(attn, k)

        x = x.flatten(2, 3)
        x = self.proj_bn(self.proj_conv(x.flatten(0, 1))).reshape(T, B, C, H, W)
        x = self.proj_lif(x)

        return x


class Spiking_Self_Attention(nn.Module):
    def __init__(self, dim, num_heads=8, qkv_bias=False, qk_scale=None, attn_drop=0., proj_drop=0., sr_ratio=1):
        super().__init__()
        assert dim % num_heads == 0, f"dim {dim} should be divided by num_heads {num_heads}."
        self.dim = dim
        self.num_heads = num_heads
        head_dim = dim // num_heads
        self.scale = 0.125
        self.q_conv = nn.Conv1d(dim, dim, kernel_size=1, stride=1,bias=False)
        self.q_bn = nn.BatchNorm1d(dim)
        self.q_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')

        self.k_conv = nn.Conv1d(dim, dim, kernel_size=1, stride=1,bias=False)
        self.k_bn = nn.BatchNorm1d(dim)
        self.k_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')

        self.v_conv = nn.Conv1d(dim, dim, kernel_size=1, stride=1,bias=False)
        self.v_bn = nn.BatchNorm1d(dim)
        self.v_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')
        self.attn_lif = MultiStepLIFNode(tau=2.0, v_threshold=0.5, detach_reset=True, backend='cupy')

        self.proj_conv = nn.Conv1d(dim, dim, kernel_size=1, stride=1)
        self.proj_bn = nn.BatchNorm1d(dim)
        self.proj_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')
        
        # self.td_linear =  nn.Conv1d( 2*dim, dim, kernel_size=1, stride=1)

        self.qkv_mp = nn.MaxPool1d(4)

    def forward(self, x, td=None):
        T, B, C, H, W = x.shape

        x = x.flatten(3)
        T, B, C, N = x.shape
        x_for_qkv = x.flatten(0, 1)
        x_feat = x
        q_conv_out = self.q_conv(x_for_qkv)
        q_conv_out = self.q_bn(q_conv_out).reshape(T,B,C,N).contiguous()
        q_conv_out = self.q_lif(q_conv_out)
        q = q_conv_out.transpose(-1, -2).reshape(T, B, N, self.num_heads, C//self.num_heads).permute(0, 1, 3, 2, 4).contiguous()

        k_conv_out = self.k_conv(x_for_qkv)
        k_conv_out = self.k_bn(k_conv_out).reshape(T,B,C,N).contiguous()
        k_conv_out = self.k_lif(k_conv_out)
        k = k_conv_out.transpose(-1, -2).reshape(T, B, N, self.num_heads, C//self.num_heads).permute(0, 1, 3, 2, 4).contiguous()

        # v_conv_out = self.v_conv(x_for_qkv)


        if td is not None:
            v_conv_out = self.v_conv(x_for_qkv)
            tdv = self.v_conv(td.flatten(0, 1).transpose(-1, -2).contiguous())
            # v_conv_out = torch.cat((v_conv_out.transpose(-1, -2), tdv.transpose(-1, -2)),dim = -1)  # 在channels维度上concat，但是是在全连接层之后
            # v_conv_out = self.td_linear(v_conv_out.transpose(-1, -2))
            v_conv_out = v_conv_out + tdv
        else:
            v_conv_out = self.v_conv(x_for_qkv)


            
        v_conv_out = self.v_bn(v_conv_out).reshape(T,B,C,N).contiguous()
        v_conv_out = self.v_lif(v_conv_out)
        v = v_conv_out.transpose(-1, -2).reshape(T, B, N, self.num_heads, C//self.num_heads).permute(0, 1, 3, 2, 4).contiguous()

        x = k.transpose(-2,-1) @ v
        x = (q @ x) * self.scale

        x = x.transpose(3, 4).reshape(T, B, C, N).contiguous()
        x = self.attn_lif(x)
        x = x.flatten(0,1)
        x = self.proj_lif(self.proj_bn(self.proj_conv(x))).reshape(T,B,C,W,H)

        return x

class TokenSpikingTransformer(nn.Module):
    def __init__(self, dim, num_heads, mlp_ratio=4., qkv_bias=False, qk_scale=None, drop=0., attn_drop=0.,
                 drop_path=0., norm_layer=nn.LayerNorm, sr_ratio=1):
        super().__init__()
        self.tssa = Token_QK_Attention(dim, num_heads)
        mlp_hidden_dim = int(dim * mlp_ratio)
        self.mlp = MLP(in_features= dim, hidden_features=mlp_hidden_dim, drop=drop)

    def forward(self, x, td=None):

        x = x + self.tssa(x, td=td)
        x = x + self.mlp(x)

        return x


class SpikingTransformer(nn.Module):
    def __init__(self, dim, num_heads, mlp_ratio=4., qkv_bias=False, qk_scale=None, drop=0., attn_drop=0.,
                 drop_path=0.0,  # 2024/11/21
                 norm_layer=nn.LayerNorm, sr_ratio=1):
        super().__init__()
        self.attn = Spiking_Self_Attention(dim, num_heads=num_heads, qkv_bias=qkv_bias, qk_scale=qk_scale,
                              attn_drop=attn_drop, proj_drop=drop, sr_ratio=sr_ratio)
        mlp_hidden_dim = int(dim * mlp_ratio)
        self.mlp = MLP(in_features=dim, hidden_features=mlp_hidden_dim, drop=drop)

        #ADD 2024/11/21
        self.drop_path1 = DropPath(0.1) 
        self.drop_path2 = DropPath(0.1) 


    def forward(self, x, td=None):

        # x = x + self.drop_path1(self.attn(x, td=td))
        # x = x + self.drop_path2(self.mlp(x))

        x = x + self.attn(x, td=td)
        x = x + self.mlp(x)

        return x


class PatchEmbedInit(nn.Module):
    def __init__(self, img_size_h=128, img_size_w=128, patch_size=4, in_channels=2, embed_dims=256):
        super().__init__()
        self.image_size = [img_size_h, img_size_w]      # 图片大小
        patch_size = to_2tuple(patch_size)              # （16， 1）
        self.patch_size = patch_size
        self.C = in_channels
        self.H, self.W = self.image_size[0] // patch_size[0], self.image_size[1] // patch_size[1]
        self.num_patches = self.H * self.W
        # Downsampling + Res 0
        self.proj_conv = nn.Conv2d(in_channels, embed_dims // 2, kernel_size=3, stride=1, padding=1, bias=False)
        self.proj_bn = nn.BatchNorm2d(embed_dims // 2)
        self.proj_maxpool = torch.nn.MaxPool2d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
        self.proj_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')

        self.proj1_conv = nn.Conv2d(embed_dims // 2, embed_dims, kernel_size=3, stride=1, padding=1, bias=False)
        self.proj1_bn = nn.BatchNorm2d(embed_dims)
        self.proj1_maxpool = torch.nn.MaxPool2d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
        self.proj1_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')

        self.proj2_conv = nn.Conv2d(embed_dims, embed_dims, kernel_size=3, stride=1, padding=1, bias=False)
        self.proj2_bn = nn.BatchNorm2d(embed_dims)
        self.proj2_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')

        self.proj_res_conv = nn.Conv2d(embed_dims // 2, embed_dims, kernel_size=1, stride=2, padding=0, bias=False)
        self.proj_res_bn = nn.BatchNorm2d(embed_dims)
        self.proj_res_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')


    def forward(self, x):
        T, B, C, H, W = x.shape
        # Downsampling + Res
        x = self.proj_conv(x.flatten(0, 1))
        x = self.proj_bn(x)
        x = self.proj_maxpool(x).reshape(T, B, -1, H//2, W//2).contiguous()
        x = self.proj_lif(x).flatten(0, 1).contiguous()

        x_feat = x
        x = self.proj1_conv(x)
        x = self.proj1_bn(x)
        x = self.proj1_maxpool(x).reshape(T, B, -1, H // 4, W // 4).contiguous()
        x = self.proj1_lif(x).flatten(0, 1).contiguous()

        x = self.proj2_conv(x)
        x = self.proj2_bn(x).reshape(T, B, -1, H//4, W//4).contiguous()
        x = self.proj2_lif(x)

        x_feat = self.proj_res_conv(x_feat)
        x_feat = self.proj_res_bn(x_feat).reshape(T, B, -1, H//4, W//4).contiguous()
        x_feat = self.proj_res_lif(x_feat)

        x = x + x_feat # shortcut

        return x

class PatchEmbeddingStage(nn.Module):
    def __init__(self, img_size_h=128, img_size_w=128, patch_size=4, in_channels=2, embed_dims=256):
        super().__init__()
        self.image_size = [img_size_h, img_size_w]
        patch_size = to_2tuple(patch_size)
        self.patch_size = patch_size
        self.C = in_channels
        self.H, self.W = self.image_size[0] // patch_size[0], self.image_size[1] // patch_size[1]
        self.num_patches = self.H * self.W

        self.proj3_conv = nn.Conv2d(embed_dims//2, embed_dims, kernel_size=3, stride=1, padding=1, bias=False)
        self.proj3_bn = nn.BatchNorm2d(embed_dims)
        self.proj3_maxpool = torch.nn.MaxPool2d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
        self.proj3_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')

        self.proj4_conv = nn.Conv2d(embed_dims, embed_dims, kernel_size=3, stride=1, padding=1, bias=False)
        self.proj4_bn = nn.BatchNorm2d(embed_dims)
        self.proj4_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')

        self.proj_res_conv = nn.Conv2d(embed_dims//2, embed_dims, kernel_size=1, stride=2, padding=0, bias=False)
        self.proj_res_bn = nn.BatchNorm2d(embed_dims)
        self.proj_res_lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')

    def forward(self, x):
        T, B, C, H, W = x.shape
        # Downsampling + Res

        x = x.flatten(0, 1).contiguous()
        x_feat = x

        x = self.proj3_conv(x)
        x = self.proj3_bn(x)
        x = self.proj3_maxpool(x).reshape(T, B, -1, H//2, W//2).contiguous()
        x = self.proj3_lif(x).flatten(0, 1).contiguous()

        x = self.proj4_conv(x)
        x = self.proj4_bn(x).reshape(T, B, -1, H//2, W//2).contiguous()
        x = self.proj4_lif(x)

        x_feat = self.proj_res_conv(x_feat)
        x_feat = self.proj_res_bn(x_feat).reshape(T, B, -1, H//2, W//2).contiguous()
        x_feat = self.proj_res_lif(x_feat)

        x = x + x_feat # shortcut

        return x

class hierarchical_spiking_transformer(nn.Module):
    def __init__(self,
                 T=4,
                 img_size_h=128, img_size_w=128, patch_size=16, in_channels=2, num_classes=11,
                 embed_dims=[64, 128, 256], num_heads=[1, 2, 4], mlp_ratios=[4, 4, 4], qkv_bias=False, qk_scale=None,
                 drop_rate=0., attn_drop_rate=0., drop_path_rate=0., norm_layer=nn.LayerNorm,
                 depths=[6, 8, 6], sr_ratios=[8, 4, 2], 
                 td = False, lif_mode ='lif',norm_layer_td = 'none',res = False, kd = False,
               
                 ):
        
        super().__init__()
        self.num_classes = num_classes
        self.depths = depths
        self.T = T
        self.td = td
        dpr = [x.item() for x in torch.linspace(0, drop_path_rate, depths)]  # stochastic depth decay rule
        
        patch_embed1 = PatchEmbedInit(img_size_h=img_size_h,
                                 img_size_w=img_size_w,
                                 patch_size=patch_size,
                                 in_channels=in_channels,
                                 embed_dims=embed_dims // 4)

        stage1 = nn.ModuleList([TokenSpikingTransformer(
            dim=embed_dims // 4, num_heads=num_heads, mlp_ratio=mlp_ratios, qkv_bias=qkv_bias,
            qk_scale=qk_scale, drop=drop_rate, attn_drop=attn_drop_rate, drop_path=dpr[j],
            norm_layer=norm_layer, sr_ratio=sr_ratios)
            for j in range(1)])

        patch_embed2 = PatchEmbeddingStage(img_size_h=img_size_h,
                                       img_size_w=img_size_w,
                                       patch_size=patch_size,
                                       in_channels=in_channels,
                                       embed_dims=embed_dims // 2)


        stage2 = nn.ModuleList([TokenSpikingTransformer(
            dim=embed_dims // 2, num_heads=num_heads, mlp_ratio=mlp_ratios, qkv_bias=qkv_bias,
            qk_scale=qk_scale, drop=drop_rate, attn_drop=attn_drop_rate, drop_path=dpr[j],
            norm_layer=norm_layer, sr_ratio=sr_ratios)
            for j in range(2)])


        patch_embed3 = PatchEmbeddingStage(img_size_h=img_size_h,
                                       img_size_w=img_size_w,
                                       patch_size=patch_size,
                                       in_channels=in_channels,
                                       embed_dims=embed_dims)

        stage3 = nn.ModuleList([SpikingTransformer(
            dim=embed_dims, num_heads=num_heads, mlp_ratio=mlp_ratios, qkv_bias=qkv_bias,
            qk_scale=qk_scale, drop=drop_rate, attn_drop=attn_drop_rate, drop_path=dpr[j],
            norm_layer=norm_layer, sr_ratio=sr_ratios)
            for j in range(depths - 3)])

        setattr(self, f"patch_embed1", patch_embed1)
        setattr(self, f"patch_embed2", patch_embed2)
        setattr(self, f"patch_embed3", patch_embed3)
        setattr(self, f"stage1", stage1)
        setattr(self, f"stage2", stage2)
        setattr(self, f"stage3", stage3)

        # classification head 这里不需要脉冲，因为输入的是在T时长平均发射值
        self.head = nn.Linear(embed_dims, num_classes) if num_classes > 0 else nn.Identity()
        
        # changed on 10-14

        if self.td:

            self.prompt = nn.Parameter(torch.randn(embed_dims),requires_grad=True)
            self.lif = MultiStepLIFNode(tau=2.0, detach_reset=True, backend='cupy')
            self.aug = 1
            #print("here")
            #ADD 2024/11/22
            # self.aug = nn.Parameter(torch.tensor(1.0,requires_grad=True))

            self.td_depth = depths - 3

            # self.decoder = nn.ModuleList([
            #     nn.ModuleList([Decoder1(embed_dims, embed_dims, self.T) for _ in range(self.td_depth)])])
            # self.decoder = nn.ModuleList([    #old
                # nn.ModuleList([Decoder1(embed_dims, embed_dims, self.T,res = False) for _ in range(depths -3)])])
            # self.decoder = nn.ModuleList([    #new
            #     nn.ModuleList([Decoder1(embed_dims, embed_dims, 1,res = False) for _ in range(depths -3)])])
            self.decoder = Decoder1(embed_dims, embed_dims, 1,res = False,norm_layer_td = 'none')
            
            
            
            print("The top-down aug is",self.aug," top-down decoder is\n")
            print(self.decoder)
        
        self.kd = kd
        if self.kd:
            print("using kd")
            self.head_kd = (
                nn.Linear(embed_dims, num_classes)
                if num_classes > 0
                else nn.Identity()
            )
        


        self.apply(self._init_weights)

    @torch.jit.ignore
    def _get_pos_embed(self, pos_embed, patch_embed3, H, W):
        if H * W == self.patch_embed3.num_patches:
            return pos_embed
        else:
            return F.interpolate(
                pos_embed.reshape(1, patch_embed3.H, patch_embed3.W, -1).permute(0, 3, 1, 2),
                size=(H, W), mode="bilinear").reshape(1, -1, H * W).permute(0, 2, 1)

    def _init_weights(self, m):
        if isinstance(m, nn.Linear):
            trunc_normal_(m.weight, std=.02)
            if isinstance(m, nn.Linear) and m.bias is not None:
                nn.init.constant_(m.bias, 0)
        elif isinstance(m, nn.LayerNorm):
            nn.init.constant_(m.bias, 0)
            nn.init.constant_(m.weight, 1.0)

    # changed on 10-14
    def feedback(self, x):
        T,B,C,N = x.shape
        

        td = []

        x = x.transpose(-1,-2) # T B N C

        #NOTE is this effective?
        # cos_sim = F.normalize(x,dim=-1) @ F.normalize(self.prompt[None, ..., None],dim=1) 

        #Which is more friendly to SNN hardware 2024/12/6
        cos_sim = x @ F.normalize(self.prompt[None, ..., None],dim=1)
        
        # mask = cos_sim
        mask = cos_sim.clamp(0,1) * 2
        # mask = cos_sim
        
        x = x * mask 
        
        x = self.lif(x)       # is more hardware-friendly

        x = x.flatten(0,1)      # TB N C

        # for module_list in self.decoder:
        #     # print(module_list)
        #     for module in module_list:
          
        #         x = module(x) 
          
        #         _, new_N, new_C = x.shape

        #         td.append(x.reshape(T, B, new_N, new_C))
        x = self.decoder(x)
        _, new_N, new_C = x.shape
        td.append(x.reshape(T, B, new_N, new_C))
        
               
             
        return td



    def forward_features(self, x, td=None):  # changed on 10-14
        if not self.td:
            stage1 = getattr(self, f"stage1")
            stage2 = getattr(self, f"stage2")
            stage3 = getattr(self, f"stage3")
            patch_embed1 = getattr(self, f"patch_embed1")
            patch_embed2 = getattr(self, f"patch_embed2")
            patch_embed3 = getattr(self, f"patch_embed3")
            

            x = patch_embed1(x)
            # print("patch_embed1")
            # print(x.shape)
            
            for blk in stage1:
                x = blk(x)
            # print("stage1")
            # print(x.shape)

            x = patch_embed2(x)
            # print("patch_embed2")
            # print(x.shape)
            
            for blk in stage2:
                x = blk(x)
            
            # print("stage2")
            # print(x.shape)/

            x = patch_embed3(x)
            # print("patch_embed3")
            # print(x.shape)
            
            for blk in stage3:
                x = blk(x)
            # print("stage3")
            # print(x.shape)
        
            return x.flatten(3).mean(3) 
        
        else:
            tmp = None
            stage1 = getattr(self, f"stage1")
            stage2 = getattr(self, f"stage2")
            stage3 = getattr(self, f"stage3")
            patch_embed1 = getattr(self, f"patch_embed1")
            patch_embed2 = getattr(self, f"patch_embed2")
            patch_embed3 = getattr(self, f"patch_embed3")

            ################  2025-2-20 ################
            x = patch_embed1(x)  
            for i, blk in enumerate(stage1):
                x = blk(x)
            x = patch_embed2(x)       
            for i, blk in enumerate(stage2):
                x = blk(x)
            x = patch_embed3(x)
            
            for i, blk in enumerate(stage3):
                if i == 6:
                    # print("top_down,",i)
                    x = blk(x,td[0]) if td is not None else blk(x)
             
          
                # if True:
                #     x = blk(x,td[i]) if td is not None else blk(x)
                #     if td is not None:
                #         print(calculate_firing_rate(td[i]))
                #         print(i)
                    
                else:
                    # print("notop_down",i)
                    x = blk(x)
            
            return x
            ################  2025-2-20 ################




            ############## traditional #################
            # if td is None:
            #     # 
            #     x = patch_embed1(x)     
            #     for i, blk in enumerate(stage1):
            #         x = blk(x)
            #     x = patch_embed2(x)        
            #     for i, blk in enumerate(stage2):
            #         x = blk(x)
            #     x = patch_embed3(x)
            #     tmp = x
            #     for i, blk in enumerate(stage3):
            #         # if i == len(stage3) - self.td_depth:
            #         #     tmp = x
            #         x = blk(x)
            #     return x, tmp
            # # tmp = x
            # else:   # traditional
            #     for i, blk in enumerate(stage3):
            #         # if self.td and i >= len(stage3) - self.td_depth :
            #         #     # x = blk(x,td[i]) if td is not None else blk(x)

            #         #     x = blk(x,td[i-len(stage3) + self.td_depth])

            #         # else:
            #         #     x = blk(x)
            #         x = blk(x,td[i]) if td is not None else blk(x)
            #     return x  # x (T, B, C, H, W), tmp (T, B, C, H, W)
            ############## traditional #################
            

    def forward(self, x, td=None):
        if not self.td:
            T = self.T  
            x = (x.unsqueeze(0)).repeat(T, 1, 1, 1, 1)
            x = self.forward_features(x) # T, B, C
            x = self.head(x.mean(0))   
            return x   
        # changed on 10-14
        else:
            ######## traditional no more flops ########
            # if td is None:  #frist time feedforward 
            #     T = self.T
            #     x = (x.unsqueeze(0)).repeat(T, 1, 1, 1, 1)
                
            #     # traditional #
            #     # xtd, tmp = self.forward_features(x, td=None)
            #     xtd = self.forward_features(x, td=None)
                
            #     xtd = xtd.flatten(3) # T, B, C, N
            #     td = self.feedback(xtd)
           
            #     x = xtd
            #     x = x.mean(3)

        
            #     x = self.head(x.mean(0)) 
                    
            #     return x,td,0

            # else:   #second time feedforward
            #     # new #
            #     T = self.T  
            #     x = (x.unsqueeze(0)).repeat(T, 1, 1, 1, 1)
            #     # new #
                
            #     x= self.forward_features(x, td)

            #     x = x.flatten(3).mean(3)

            
            #     if self.kd:
            #         x_kd = self.head_kd(x.mean(0))
            #         x = self.head(x.mean(0)) 
            #         if self.training:
            #             return x,x_kd
            #         else:
            #             return (x+x_kd)/2
                    
            #     else:
            #         x = self.head(x.mean(0)) 
            #         return x
            
            ##########   NEW  ##########  
            T = 1
            x = (x.unsqueeze(0)).repeat(T, 1, 1, 1, 1)
            xtd = self.forward_features(x, td=td)
            xtd = xtd.flatten(3) # T, B, C, N
            td = self.feedback(xtd)
            x = self.head(xtd.mean(3).mean(0))
            return x,td
                
            
            

            


def QKFormer_10_384(T=1, **kwargs):
    model = hierarchical_spiking_transformer(
        T=T,
        img_size_h=224, img_size_w=224,
        patch_size=16, embed_dims=384, num_heads=6, mlp_ratios=4,
        in_channels=3, num_classes=1000, qkv_bias=False,
        norm_layer=partial(nn.LayerNorm, eps=1e-6), depths=10, sr_ratios=1,
        **kwargs
    )
    return model

def QKFormer_10_512(T=1, **kwargs):
    model = hierarchical_spiking_transformer(
        T=T,
        img_size_h=224, img_size_w=224,
        patch_size=16, embed_dims=512, num_heads=8, mlp_ratios=4,
        in_channels=3, num_classes=1000, qkv_bias=False,
        norm_layer=partial(nn.LayerNorm, eps=1e-6), depths=10, sr_ratios=1,
        **kwargs
    )
    return model


def QKFormer_10_768(T=1, finetune = None,**kwargs):
    model = hierarchical_spiking_transformer(
        T=T,
        img_size_h=224, img_size_w=224,
        patch_size=16, embed_dims=768, num_heads=12, mlp_ratios=4,
        in_channels=3, num_classes=1000, qkv_bias=False,
        norm_layer=partial(nn.LayerNorm, eps=1e-6), depths=10, sr_ratios=1,
        **kwargs
    )
    return model


# changed on 2025-02-20
def QKFormer_10_768_cam(T=1, finetune = None,**kwargs):
    model = hierarchical_spiking_transformer(
        T=T,
        patch_size=16, embed_dims=768, num_heads=12, mlp_ratios=4,
        in_channels=3, num_classes=1000, qkv_bias=False,
        norm_layer=partial(nn.LayerNorm, eps=1e-6), depths=10, sr_ratios=1,
        **kwargs
    )
    if finetune is not None:
        
        checkpoint = torch.load(finetune)
        pretrain_dict = checkpoint['model']
        model_dict = model.state_dict()

        pretrain_dict = {k:v for k,v in pretrain_dict.items() if k in model_dict}
        # pretrain_dict = {k:v for k,v in pretrain_dict.items() if k in model_dict}

        backbone_dict = {k:v for k,v in model_dict.items() if k not in pretrain_dict}


        model_dict.update(pretrain_dict)

        model.load_state_dict(model_dict)

        for name,param in model.named_parameters():
            if name in pretrain_dict  :
                
                print(f"{name} loaded from pretrained model")
                # param.requires_grad = False
              
            if name in backbone_dict:
                print(f"{name} random initialised and also can be trained")
                continue
    
        return model
    
    return model


@register_model
def QKFormer_10_768_td(T=1,finetune = None,kd = False ,**kwargs):
    model = hierarchical_spiking_transformer(
        T=T,
        img_size_h=224, img_size_w=224,
        patch_size=16, embed_dims=768, num_heads=12, mlp_ratios=4,
        in_channels=3, num_classes=1000, qkv_bias=False,
        norm_layer=partial(nn.LayerNorm, eps=1e-6), depths=10, sr_ratios=1, 
        td=True, kd = kd ,
        **kwargs
    )

    if finetune is not None:
        
        checkpoint = torch.load(finetune)
        pretrain_dict = checkpoint['model']
        model_dict = model.state_dict()

        pretrain_dict = {k:v for k,v in pretrain_dict.items() if k in model_dict and k != 'head.weight' and k != 'head.bias'}
        # pretrain_dict = {k:v for k,v in pretrain_dict.items() if k in model_dict}

        backbone_dict = {k:v for k,v in model_dict.items() if k not in pretrain_dict}


        model_dict.update(pretrain_dict)

        model.load_state_dict(model_dict)

        for name,param in model.named_parameters():
            if name in pretrain_dict  :
                
                print(f"{name} loaded from pretrained model")
                # param.requires_grad = False
              
            if name in backbone_dict:
                print(f"{name} random initialised and also can be trained")
                continue
    
        return model
    
    return model

if __name__ == '__main__':
    H = 224
    W = 224
    x = torch.randn(2, 3, 224, 224).cuda()
    model = QKFormer_10_768(T = 4).cuda()
    #for param in model.model.decoder_stage_3.parameters():
    #    param.requires_grad = False
    model.eval()
    result_1 = model(x)
    assert False
    print(result_1.shape, result_2.shape)
    n_parameters = sum(p.numel() for p in model.parameters() if p.requires_grad)
    print('number of params (M): %.2f' % (n_parameters / 1.e6))
   
    model.eval()
    from torchinfo import summary
    summary(model, input_size=(1, 3, 224, 224))
    # QKFormer_10_768 not top-down is 64.96M
