import numpy as np
from GraphL_Utils import plot_boxplot, PlotCore, SBMDistProp, MMSBMDistProb, plotScatter
from GraphL_Utils import plot_single_regression, relPlot, df_empty, plot_line, vecNormalize
import pandas as pd
from datetime import datetime
import itertools
import sys
import seaborn as sns
import pandas as pd
from ast import literal_eval
import os

def flatten(t):
    return [item for sublist in t for item in sublist]

windows = True
fileName = 'Fig_m_coarseOut_n5000_K5_m20_Dirch04_Qassortative_symmetric_pureX1'
# 'Fig1_coarseOut_n5000_K5_m200_r4_Dirch04_Qassortative-symmetric_pureX1'
errorType = 'L1_minus1_sumNorm'
folderName = 'Oct 5 Figs/' # 'Sep 8 Figs/'

cd = os.getcwd()
os.chdir(folderName)

df = pd.read_csv(fileName+'.csv', converters={'avg_fineProjected': literal_eval}) 
# , 'avg_estComtyBased_coarse':literal_eval, 'coarseMembershipMatrix':literal_eval # pd.eval # 'out_wrt_measurementSize_for_p.csv' , 'out_wrt_coverage_for_nu.csv'
    
# print(df[['n', 'm', 'r', 'K', 'p', 'q', 'overlap', 'comSizeMode', 'Qmode']].join(df.loc[:, df.columns.str.contains(errorType)]))




df = df.rename(columns={'avg_fineProj '+errorType+' error': 'MOR Error',\
                        'avg_estComtyBased_fineProj '+errorType+' error': 'Learning Error',\
                        'random '+errorType+' error': 'Baseline Error'})
df = df[(df['overlap']<=10)]
# df = df[(df['n']==5000)]
# df = df[(df['avg_estComtyBased_coarse']>=0)]





x_col = 'm' # 'overlap' # 'densityScaling' # 'm' # 'Heterogeneity of Community Sizes' # 'densityScaling' # 'r' # 'Qmode' # 'n' # 
title = 'Error'
figName = fileName +  '_' + x_col + '_' + title


# figName = title + '_wrt_{}_n{}_m{}_K{}'.format(x_col, n_array[0], m_array[0], K_array[0])
if(True):
    value_cols = ['Baseline Error', 'MOR Error', 'Learning Error']
    varName = 'Error Type'
    y_col = 'Error'
    df = df.melt(id_vars=list(set(df.columns).difference(set(value_cols))), value_vars=value_cols, \
                                        value_name=y_col, var_name=varName)
    relPlot(df, x_col=x_col, y_col=y_col, hue_col=varName, style_col=varName, \
                            plot_core=PlotCore(title='', figName=figName, \
                                saveFlag=True, showFlag=windows, log_scale=True, log_xscale=False, aspect=0.8, figsize=None, dpi=500, \
                                    minX_axis=np.min(df[x_col])*0.95, maxX_axis=np.max(df[x_col])*1.05,\
                                        minY_axis=np.min(df[y_col])*0.95, maxY_axis=np.max(df[y_col])*1.05, palette_cmap='tab10', \
                                             paper_rc = {'lines.linewidth': 4, 'lines.markersize': 8} )) # 
    # palettes = ['BuPu', 'hot', sns.color_palette("mako_r", 6) , "tab10", 'RdYlBu' , 'Paired' , 'Dark2', "Reds", sns.cubehelix_palette(8)]
elif(True):
    value_cols = ['MOR Error', 'Learning Error']
#     df.loc[df.comSizeMode == 0, "comSizeMode"] = 'high'
#     df.loc[df.comSizeMode == 1, "comSizeMode"] = 'medium'
#     df.loc[df.comSizeMode == 2, "comSizeMode"] = 'low'
    df = df.rename(columns={'comSizeMode': 'Heterogeneity of Community Sizes'})
    if('Qmode' in df.columns):
        df.loc[df.Qmode == 'assortative_symmetric', "Qmode"] = 'assortative'
        df.loc[df.Qmode == 'disassortative_symmetric', "Qmode"] = 'disassortative'
    plot_boxplot(df, groupby_col=x_col, target_cols=value_cols, plot_core=PlotCore(title='', figName=figName, \
                                saveFlag=True, showFlag=windows, log_scale=True, aspect=1, figsize=(12,5)))
else:
    df_exp = pd.DataFrame()
    df_exp['Average Contollability'] = flatten([df['avg_fineProjected'][i] for i in np.arange(df.shape[0])])
    df_exp['Overlap Extent'] = flatten([literal_eval(df['coarseMembershipMatrix'][i]) for i in np.arange(df.shape[0])])
    
os.chdir(cd)
    
#     sns.jointplot(x=tips['total_bill'], y=tips['tip'], kind='reg')
    
    
    
    