from collections import defaultdict
import nltk
from nltk.corpus import wordnet as wn
from nltk.corpus.reader.wordnet import Synset
import warnings

warnings.filterwarnings('ignore', category=UserWarning)
nltk.download('wordnet')
nltk.download('omw-1.4')


def get_synset(wnid):
    id_str, id_int = wnid[0], int(wnid[1:])
    synset = wn.synset_from_pos_and_offset(id_str, id_int)
    return synset

def get_name(word):
    if not isinstance(word, Synset): synset = get_synset(word)
    else: synset = word
    return synset.lemma_names()[0]

def get_wnid(synset):
    return synset.pos() + str(synset.offset()).zfill(8)

def get_hyper_hypo_maps(hypos):
    assert isinstance(hypos, list)
    hyper = lambda s: s.hypernyms()
    hyper_hypo_map = defaultdict(list)
    hypo_hyper_map = defaultdict(list)
    for i, hypo in enumerate(hypos):
        if not isinstance(hypo, Synset):
            hypo = get_synset(hypo)
        hypernyms_temp = hypo.closure(hyper)
        hypo_hyper_map[i] = list({get_wnid(hypernym) for hypernym in hypernyms_temp})
        hypo_hyper_map[i].sort()
        for hypernym_id in hypo_hyper_map[i]:
            hyper_hypo_map[hypernym_id].append(i)
            hyper_hypo_map[hypernym_id].sort()
    return hyper_hypo_map, hypo_hyper_map
