#!/bin/bash

# Initialize parameters - GPU KV cache 4 GiB 제한
device_id=1
file_path=LongBench_DS_8B_GovReport
# 로그 디렉토리 생성
mkdir -p ./$file_path

# 모델 설정
llm_model=deepseek-ai/DeepSeek-R1-Distill-Llama-8B
#llm_model=meta-llama/Llama-3.3-70B-Instruct
#llm_model=deepseek-ai/DeepSeek-R1-Distill-Qwen-32B

# 데이터셋 설정
dataset_path=THUDM/LongBench
dataset_name=gov_report_e # GovReport (8,734) 

# 밴치마크 파라미터
#output_len=10240  # 긴 출력으로 메모리 압박 증가
n=1  # 배치 사이즈를 10개로 증가

# GPU KV cache 크기 제한 (4 GiB) - 더 극한 조건
# 계산 방법:
# - 8B 모델의 경우 KV cache per token: ~0.5 MB
# - block_size=128 토큰
# - 4 GiB = 4096 MB
# - 필요한 블록 수: 4096 MB / (0.5 MB * 128) ≈ 64 블록
gpu_memory_utilization=0.9  # 높은 GPU 메모리 사용률
max_model_len=50000  # 긴 시퀀스 길이
max_seq_len=20000
max_num_seqs=16  # 동시 처리 시퀀스 수 증가
block_size=64  # 블록 크기
num_gpu_blocks_override=4096  # 4 GiB KV cache를 위한 블록 수

# KV Cache 관련 옵션
swap_space=0  # 10GB swap 공간
swap_fc_space=0  # 0GB Flash Cache swap 공간
num_thread=4
num_ssd_for_fc=1  # SSD 개수
io_size_mb=4  # I/O 크기
prompts=200

#for prompts in 50 # 100 150 200
for output_len in 1000 #5000 10000  
do
    echo "Running 4GB KV cache benchmark with output_len: $output_len"
    CUDA_VISIBLE_DEVICES=$device_id python ../../benchmark_throughput_dataset.py \
        --backend vllm \
        --model $llm_model \
        --tokenizer $llm_model \
        --dataset $dataset_path \
        --dataset-name $dataset_name \
        --output-len $output_len \
        --n $n \
        --num-prompts $prompts \
        --tensor-parallel-size 1 \
        --dtype auto \
        --gpu-memory-utilization $gpu_memory_utilization \
        --preemption-mode recompute \
        --max-model-len $max_model_len \
        --max-seq-len $max_seq_len \
        --max-num-seqs $max_num_seqs \
        --block-size $block_size \
        --num-gpu-blocks-override $num_gpu_blocks_override \
        --swap-space $swap_space \
        --swap-fc-space $swap_fc_space \
        --num-thread $num_thread \
        --num-ssd-for-fc $num_ssd_for_fc \
        --io-size-mb $io_size_mb \
        --output-json "${file_path}/results_${output_len}_hbm.json" \
        > "${file_path}/benchmark_${output_len}_hbm.log" 2>&1
    echo "Completed 4GB KV cache benchmark with output_len: $output_len"
done

echo "All 4GB KV cache benchmarks completed!" 