#!/bin/bash

# Initialize parameters
file_path=swap_perf_DS_Q_32B_multi_threads
#file_path=swap_perf_LM_34B_len_test
device_id=0

#llm_model=deepseek-ai/DeepSeek-R1-Distill-Llama-8B
llm_model=deepseek-ai/DeepSeek-R1-Distill-Qwen-32B
#llm_model=meta-llama/Llama-3.3-70B-Instruct
#llm_model=codellama/CodeLlama-34b-hf
#llm_model=tiiuae/falcon-40b
#llm_model=Qwen/Qwen2.5-32B-Instruct
#hf_dataset=anon8231489123/ShareGPT_Vicuna_unfiltered

# 로그 디렉토리 생성
mkdir -p ./$file_path

#input_len=None
#output_len=None

input_len=5000
output_len=5000
#max_model_len=$((output_len + input_len))
#quantization=None
#batch_token=$max_model_len
        #--random-len \
        #--disable-log-stats \
        #--tensor-parallel-size 2 \
        #--gpu-memory-utilization 0.9 \
        #--distributed-executor-backend mp \
#--max-model-len $max_model_len \
for num_threads in 1 2 4 8 16 32 
do
    output_len=$input_len
    max_model_len=$((output_len + input_len))
    batch_tokens=$max_model_len
    num_prompts=10
    echo "Running benchmark with num_threads: $num_threads"
    CUDA_VISIBLE_DEVICES=$device_id python ../../benchmark_throughput_rand_length.py \
        --backend vllm \
        --model $llm_model \
        --tokenizer $llm_model \
        --preemption-mode swap \
        --swap-space 0 \
        --swap-fc-space 100 \
        --num-thread $num_threads \
        --io-size-mb 16 \
        --dtype auto \
        --enable_chunked_prefill true \
        --max_num_batched_tokens $batch_tokens \
        --num-prompts $num_prompts \
        --input-len $input_len \
        --output-len $output_len \
        --block-size 128 \
        --max-model-len $max_model_len \
        > "${file_path}/fc_${num_threads}.log"
    
    echo "Completed benchmark with num_threads: $num_threads"
done

echo "All benchmarks completed!" 