import re
import argparse

def calculate_avg_blocks_per_second(log_file_path, start_idx=None, end_idx=None):
    blocks_per_second_values = []
    
    with open(log_file_path, 'r') as f:
        for line in f:
            match = re.search(r'FC blocks per second: (\d+\.?\d*)', line)
            if match:
                value = float(match.group(1))
                blocks_per_second_values.append(value)
    
    if not blocks_per_second_values:
        print("No FC blocks per second values found in the log file")
        return
    
    # start_idx와 end_idx가 지정된 경우 해당 범위만 사용
    if start_idx is not None and end_idx is not None:
        if start_idx < 0 or end_idx > len(blocks_per_second_values):
            print(f"Invalid range: start={start_idx}, end={end_idx}")
            print(f"Valid range: 0 to {len(blocks_per_second_values)-1}")
            return
        blocks_per_second_values = blocks_per_second_values[start_idx:end_idx+1]
    
    avg_blocks_per_second = sum(blocks_per_second_values) / len(blocks_per_second_values)
    print(f"Average FC blocks per second: {avg_blocks_per_second:.2f}")
    print(f"Number of samples: {len(blocks_per_second_values)}")
    print(f"Min value: {min(blocks_per_second_values):.2f}")
    print(f"Max value: {max(blocks_per_second_values):.2f}")

def main():
    parser = argparse.ArgumentParser(description='Calculate average FC blocks per second from log file')
    parser.add_argument('log_file', help='Path to the log file')
    parser.add_argument('--start', type=int, help='Start index (inclusive)')
    parser.add_argument('--end', type=int, help='End index (inclusive)')
    
    args = parser.parse_args()
    
    calculate_avg_blocks_per_second(args.log_file, args.start, args.end)

if __name__ == "__main__":
    main()
