import psutil
import time

def monitor_io(device="/dev/nvme0n1"):
    while True:
        disk_io = psutil.disk_io_counters(perdisk=True)
        if device in disk_io:
            print(f"Read bytes: {disk_io[device].read_bytes}")
            print(f"Write bytes: {disk_io[device].write_bytes}")
            print(f"Read count: {disk_io[device].read_count}")
            print(f"Write count: {disk_io[device].write_count}")
        time.sleep(1)

if __name__ == "__main__":
    monitor_io()
