# code is adapted from https://github.com/.../verl-agent

set -x
ENGINE=${1:-vllm}
export HF_ENDPOINT=https://hf-mirror.com
export RAY_memory_monitor_refresh_ms=0
export CUDA_LAUNCH_BLOCKING=1
export HYDRA_FULL_ERROR=1

# Note: Our implementation uses a leave-one-out estimate and the PPO-clip update (instead of the REINFORCE update). So it is more like LOOP (https://arxiv.org/abs/2502.01600)

train_data_size=16
val_data_size=128
group_size=8
model_path=../Qwen/Qwen2.5-7B-Instruct


python3 -m examples.data_preprocess.prepare \
    --mode 'text' \
    --train_data_size $train_data_size \
    --val_data_size $val_data_size

python3 -m verl.trainer.main_ppo \
    algorithm.adv_estimator=istar_rloo \
    data.train_files=../code/data/text/train.parquet \
    data.val_files=../code/data/text/test.parquet \
    data.train_batch_size=$train_data_size \
    data.val_batch_size=$val_data_size \
    data.max_prompt_length=4096 \
    data.max_response_length=512 \
    data.filter_overlong_prompts=True \
    data.truncation='error' \
    data.return_raw_chat=True \
    actor_rollout_ref.model.path=$model_path \
    actor_rollout_ref.actor.optim.lr=5e-7 \
    actor_rollout_ref.model.use_remove_padding=True \
    actor_rollout_ref.actor.ppo_mini_batch_size=64 \
    actor_rollout_ref.actor.ppo_micro_batch_size_per_gpu=8 \
    actor_rollout_ref.actor.use_kl_loss=False \
    actor_rollout_ref.model.enable_gradient_checkpointing=True \
    actor_rollout_ref.actor.fsdp_config.param_offload=False \
    actor_rollout_ref.actor.fsdp_config.optimizer_offload=False \
    actor_rollout_ref.rollout.log_prob_micro_batch_size_per_gpu=16 \
    actor_rollout_ref.rollout.tensor_model_parallel_size=1 \
    actor_rollout_ref.rollout.name=$ENGINE \
    actor_rollout_ref.rollout.gpu_memory_utilization=0.6 \
    actor_rollout_ref.rollout.enable_chunked_prefill=False \
    actor_rollout_ref.rollout.enforce_eager=False \
    actor_rollout_ref.rollout.free_cache_engine=False \
    actor_rollout_ref.rollout.val_kwargs.temperature=0.4 \
    actor_rollout_ref.rollout.val_kwargs.do_sample=True \
    actor_rollout_ref.ref.log_prob_micro_batch_size_per_gpu=16 \
    actor_rollout_ref.ref.fsdp_config.param_offload=True \
    actor_rollout_ref.actor.use_invalid_action_penalty=True \
    actor_rollout_ref.actor.invalid_action_penalty_coef=0.1 \
    reward_model.enable=True \
    reward_model.model.ref_path=null \
    reward_model.model.path=$model_path \
    reward_model.micro_batch_size_per_gpu=8 \
    reward_model.model.update=after \
    reward_model.model.loss_type=eto \
    reward_model.model.beta_train=0.05 \
    reward_model.model.optim.lr=1e-6 \
    reward_model.model.optim.grad_clip=10.0 \
    reward_model.model.input_tokenizer=null \
    reward_model.mini_batch_size=64 \
    reward_model.num_rollout=$group_size \
    reward_model.step_granularity=step \
    algorithm.use_kl_in_reward=False \
    algorithm.gigpo.step_advantage_w=1.0 \
    env.env_name=Webshop \
    env.seed=10 \
    env.max_steps=10 \
    env.rollout.n=$group_size \
    trainer.critic_warmup=0 \
    trainer.logger=['console','swanlab'] \
    trainer.project_name='webshop' \
    trainer.experiment_name='istar_rloo' \
    trainer.n_gpus_per_node=8 \
    trainer.nnodes=1 \
    trainer.save_freq=50 \
    trainer.test_freq=5 \
    trainer.total_epochs=200 \
    trainer.val_before_train=True $@
    
    
    
    
    
    
    
