# Robot-RAG (Official implementation of RAGDP)

## Buidling docker image

First, build Docker image:

```
cd docker
export DATASET_DIR=/path/to/robomimic/datasets
./BUILD_DOCKER_IMAGE.sh
```

Then run container:

```
cd docker
./RUN_DOCKER_CONTAINER.sh
```

The container name will be `${USER}_robot_rag`.

To login the container,

```
docker exec -it ${USER}_robot_rag zsh
```


## Training

Training code for Diffusion Policy（DDPM）：

```
mkdir weights # only for first time
export WANDB_API_KEY=*******
python3 train/train_ddpm_state_condition.py -e 3000 -b 256 --task_type SQUARE --task_tag PH --save-last-checkpoints 3 --save-per-epochs 700
```


Training code for Diffusion Policy（EDM）：

```
export WANDB_API_KEY=*******
python3 train/train_edm_state_condition.py -e 3000 -b 256 --task_type SQUARE --task_tag PH --save-last-checkpoints 3 --save-per-epochs 700
```

Training code for Consistency Policy（CTM）：


```
export WANDB_API_KEY=*******
python3 train/train_ctm_state_condition.py -e 3000 -b 256 --task_type SQUARE --task_tag PH --save-last-checkpoints 3 --save-per-epochs 700 --teacher_path /path/to/EDM-MODEL-WEIGHT-FILE
```

## Inference

### Create vector database

```
python3 create_index.py --task_type SQUARE --task_tag PH --index-name square-ph.index
```

### Running Diffusion Policies

DP(DDPM):

```
python3 python3 test_ddpm_state_condition.py --task_type SQUARE --task_tag PH --checkpoint /path/to/weight/file --diffusion_timesteps 100  --max_steps 400 --index-name square-ph.index
```

DP(DDIM):

```
python3 python3 test_ddim_state_condition.py --task_type SQUARE --task_tag PH --checkpoint /path/to/weight/ddpm_file --ddim_timesteps 25 --ddim --max_steps 400 --index-name square-ph.index
```



DP(EDM):


```
python3 python3 test_edm_state_condition.py --task_type SQUARE --task_tag PH --checkpoint /path/to/weight/file --diffusion_timesteps 40  --max_steps 400 --index-name square-ph.index
```

CP(CTM):

```
python3 test_cm_state_condition_rag.py --task_type SQUARE --task_tag PH --checkpoint /path/to/weight/file --cm-steps 4 --max_steps 400 --index-name square-ph.index --no-rag
```



### Running RAGDP

An argument `--diffuse-rate` means hyperparameter `r` for RAGDP.

RAGDP-VP(DDPM)

```
python3 test_ddpm_state_condition_rag.py --task_type SQUARE --task_tag PH --checkpoint /path/to/weight/file --diffusion_timesteps 100  --max_steps 400 --index-name square-ph.index --diffuse-rate 0.25
```

RAGDP-VP(DDIM)

```
python3 test_ddim_state_condition_rag.py --task_type SQUARE --task_tag PH --checkpoint /path/to/weight/file --diffusion_timesteps 25 --max_steps 400 --index-name square-ph.index --diffuse-rate 0.25
```

RAGDP-VE(EDM)

```
python3 test_edm_state_condition_rag.py --task_type SQUARE --task_tag PH --checkpoint /path/to/weight/file --diffusion_timesteps 40  --max_steps 400 --index-name square-ph.index --diffuse-rate 0.25
```


RAGDP-VP(EDM)

```
python3 test_edm_state_condition_rag.py --task_type SQUARE --task_tag PH --checkpoint /path/to/weight/file --diffusion_timesteps 40  --max_steps 400 --index-name square-ph.index --diffuse-rate 0.25 --rag-vp 
```

For CTM models, `r = 1 - rag_steps / cm_steps`.


RAGDP-VE(CTM)

```
python3 test_cm_state_condition_rag.py --task_type SQUARE --task_tag PH --checkpoint /path/to/weight/file --cm-steps 4 --max_steps 400 --index-name square-ph.index --rag-steps 3
```

RAGDP-VP(CTM)

```
python3 test_cm_state_condition_rag.py --task_type SQUARE --task_tag PH --checkpoint /path/to/weight/file --cm-steps 4 --max_steps 400 --index-name square-ph.index --rag-steps 3 --rag-vp
```


