# reluNets
This project holds relevant code for the submission 

## Description

The repository contains code for plotting the main results in the paper.
It also contains code to run the main experiments reported in the paper.


## file structure
The file structure should should allow for reproducibility <br>

The folder `scripts/data/` should contain datasets used in the neural network experiments these need to be downloaded and we do not include them for space (such as MNIST, CIFAR-10). 
<br>

Further, `scripts/notebooks` contains `.ipynb` files used for plotting and training of models. `scripts/notebooks` contains `.ipynb` files used for the training of the models. `reluNets/` is exclusively used for reusable modules for import in other files and notebooks.

```bash
├── README.md
├── environment.yml
├── scripts
│   └── notebooks
├── setup.py
├── reluNets
│   ├── __init__.py
│   ├── ...
```

## Dependencies

* All analyses were created on Mac OS, dependencies are contained in environment.yml file. We used Pytorch for our neural network experiments. 

## Getting Started
The environment.yml file will install the cpu-only version of Pytorch. This is sufficient to run network experiments without issue and the experiments on should take only few minutes to run.

1. Recreate conda environment:
   ```
   conda env create --file environment.yml
   ```
   Then run
   ```
   conda activate reluNets
   ```
2. Install code in `reluNets/` as editable package (run this in the root folder):
   ```
   pip install -e .
   ```

## Usage
Relevant plots can be generated using the .ipynb files in the notebooks folder. <br>
Specifically, to reproduce the figures of the main text: Figure 1 can be reproduced by running notebooks `scripts/notebooks/relu_net_MNIST.ipynb` and `scripts/notebooks/relu_net_MNIST_final_test_error.ipynb`, Figure 2 can be reproduced by running `scripts/notebooks/relu_net_hierarchy.ipynb`, `scripts/notebooks/relu_net_xor.ipynb` and `scripts/notebooks/relu_net_hierarchy_MDS_plot.ipynb`. Figure 3 can be reproduced by running `scripts/notebooks/relu_net_hierarchy_hidden.ipynb` and `scripts/notebooks/hierarchy/relu_net_hierarchy_exact_sol_t_star.ipynb`. Figure 4 can be reproduced from `scripts/notebooks/hierarchy/relu_net_hierarchy_exact_sol_t_star.ipynb`, Figure 5 can be reproduced from `scripts/notebooks/relu_net_3d_xor.ipynb` and `scripts/notebooks/relu_net_3d_xor_decision_boundary.ipynb`. Finally, figure 6 can be reproduced by running `scripts/notebooks/relu_net_linear_to_nonlinear.ipynb`.

