# Copyright (c) Facebook, Inc. and its affiliates.
from . import data  # register all new datasets
from . import modeling
# config
from .config import (add_colorization_config, add_dropout_config,
                     add_maskformer2_config, add_maskformer_vit_config,
                     add_pretrain_config, add_ttt_config)
# dataset loading
from .data.dataset_mappers.coco_instance_new_baseline_dataset_mapper import \
    COCOInstanceNewBaselineDatasetMapper
from .data.dataset_mappers.coco_panoptic_new_baseline_dataset_mapper import \
    COCOPanopticNewBaselineDatasetMapper
from .data.dataset_mappers.colorization_dataset_mapper import (
    ColorizationDatasetMapper, colorization_collation)
from .data.dataset_mappers.dropout_concat_semantic_dataset_mapper import \
    DropoutConcatSemanticDatasetMapper
from .data.dataset_mappers.dropout_semantic_dataset_mapper import \
    DropoutSemanticDatasetMapper
from .data.dataset_mappers.instance_pretrain_dataset_mapper import \
    InstancePretrainDatasetMapper
from .data.dataset_mappers.mask_former_instance_dataset_mapper import \
    MaskFormerInstanceDatasetMapper
from .data.dataset_mappers.mask_former_panoptic_dataset_mapper import \
    MaskFormerPanopticDatasetMapper
from .data.dataset_mappers.mask_former_semantic_dataset_mapper import \
    MaskFormerSemanticDatasetMapper
from .data.dataset_mappers.panoptic_pretrain_dataset_mapper import \
    PanopticPretrainDatasetMapper
from .data.dataset_mappers.semantic_pretrain_dataset_mapper import (
    SemanticPretrainDatasetMapper, mask_collation)
from .evaluation.colorization_evaluation import ColorizationEvaluator
# evaluation
from .evaluation.instance_evaluation import InstanceSegEvaluator
from .maskformer_col_model import MaskFormerColorization
# models
from .maskformer_model import MaskFormer
from .maskformer_ttt_model import MaskFormerTTT
from .test_time_augmentation import SemanticSegmentorWithTTA
