# IMPORTANT
# Across GPUs, we vary by FOLDER (not confidence)

import shutil
import argparse
import subprocess
import os
import sys
import numpy as np

# -define and run HPs
#     -used ratio: 0.1, 0.2, 0.3, 0.4, 0.5
#     -mask ratio: 0.6, 0.7, 0.8, 0.9, 0.95
#     -videos: 0001, 0019, 0020
#     -win size: 1, 2, 4, 8

parser = argparse.ArgumentParser(allow_abbrev=False)
parser.add_argument(
    '--gpu',
    type=str,
    default=None,
    help="CUDA_VISIBLE_DEVICES parameter"
)

parser.add_argument(
    '--used', 
    nargs='+', 
    type=float, 
    default=None,
    help="Top k% most confident"
)


parser.add_argument(
    '--videos', 
    nargs='+', 
    type=str, 
    default=None,
    help="Videos to run on"
)



args = parser.parse_args()


if __name__ == '__main__':
    max_iters = 10

    # exp_log_dir = os.path.join('exp_dir', os.path.basename(args))
    # model_output_dir = os.path.join('output', os.path.basename(args.ttt_output))

    os.environ["CUDA_DEVICE_ORDER"] = "PCI_BUS_ID"
    os.environ["CUDA_VISIBLE_DEVICES"] = args.gpu

    train_set = ["0000",  "0001",  "0003",  "0004",  "0005",  "0009",  "0011",  "0012",  "0015",  "0017",  "0019",  "0020"]
    val_set = ["0002",  "0006",  "0007",  "0008",  "0010",  "0013",  "0014",  "0016",  "0018"]

    for vid in args.videos:
        split = "train" if vid in train_set else "val"
        for conf in args.used:
            input_label_dir = os.path.join("../../../../datasets/kitti_step/panoptic_maps",
                                            split, vid)
            in_dir = os.path.join("../../../../datasets/kitti_step/images", 
                                            split, vid)
            in_images = os.path.join(in_dir, "*.png")
            ttt_output = os.path.join("../../../../datasets/kitti_step/dropout_video", 
                                str(conf), "train", vid)

            # import ipdb; ipdb.set_trace()       # Check that all params are as expected

            # If directory does not exist, we will copy the required training images and labels
            if not os.path.exists(ttt_output):
                shutil.copytree(in_dir, ttt_output)
                ttt_label_output = os.path.join("../../../../datasets/kitti_step/dropout_video", 
                                str(conf), "val", vid)
                shutil.copytree(input_label_dir, ttt_label_output)

            # 2. Run demo
            subprocess.run([
                sys.executable, "demo/demo_dropout.py",
                # "--config-file", "configs/kitti_step/semantic-segmentation/swin/maskformer2_swin_tiny_bs16_90k.yaml",
                "--config-file", "configs/kitti_step/semantic-segmentation/swin/maskformer2_swin_small_bs16_90k.yaml",
                "--ttt",
                "--drop_aug",
                "--topl", str(conf),
                "--input_label_dir", input_label_dir,
                "--input", in_images,
                "--ttt_output", ttt_output,
                # "--opts", "MODEL.WEIGHTS", "../../../../checkpoints/maskformer_swin_t_sem_cityscapes.pkl",
                "--opts", "MODEL.WEIGHTS", "../../../../checkpoints/maskformer_swin_s_sem_cityscapes.pkl",
            ], check=True)        


