#!/bin/bash
logdir="./logs"
if [ "$#" -le 2 ]
then
    echo "Usage:       ./run_cifar100_hpcc.sh <seed> <algorithm> <if_run> "
    echo "Example:     ./run_cifar100_hpcc.sh 1 PRL_innerMax 0"
    exit
else
    #  1 10 50 100 500 1000 5000 10000
    seed=$1
    alg=$2
    running=$3
    dataset='cifar100'
    batch_size=128
    max_epochs=100
    eps_neighbor=0.05
    alpha=0.0
    drop_decay_step=0
    for corruption_rate in 0.15 0.25 0.35 0.45
        do
        pids=() # rest process id array
        echo ""
        for corruption_type in 'patch' 'blend'
             do
                 log_path="$logdir/$dataset/$alg/corr$corruption_rate/$corruption_type"
                 mkdir -p $log_path
                 cmd="python3 Solvers_BackDoor/${alg}.py  --data_name $dataset --batch_size $batch_size --seed $seed --corruption_rate $corruption_rate --max_epochs $max_epochs --corruption_type $corruption_type --eps_neighbor $eps_neighbor --alpha $alpha --drop_decay_step $drop_decay_step &> ${log_path}/seed_$seed.log &"
                 echo $cmd
                 if [ "$running" == "1" ]; then
                    eval $cmd
                  else
                    echo "not run"
                 fi
                 pids+=($!) # add current id to the pIDs array
             done
         wait "${pids[@]}" # wait for the same corruption_type jobs finish before running new ones
        done
fi
