#!/bin/bash
# prefix="/mnt/research-share/projects/zhuzhuan/"
logdir="/localscratch/liuboya2/DefenseBackdoorAttack/Result/logs"
if [ "$#" -le 0 ]
then
    echo "Usage:       ./run_cifar100.sh <if_run> "
    echo "Example:     ./run_cifar100.sh 0  "
    exit
else
    #  1 10 50 100 500 1000 5000 10000
    running=$1
    dataset='cifar100'
    batch_size=128
    max_epochs=100
    corruption_type='patch'
#    corruption_type='blend'
    eps_neighbor=0.05
    alpha=0.0
    drop_decay_step=0

    for seed in 0
        do
#            for alg in PRL SPL PRL_innerMax SPL_InnerMax BootStrap Bootstrap_InnerMax Standard GaussianAug simclr
            for alg in simclr
                do
                pids=() # rest process id array
                echo ""
                for corruption_rate in 0.15 0.25 0.35 0.45
                    do
                        log_path="$logdir/$dataset/$alg/corr$corruption_rate/$corruption_type"
                        mkdir -p $log_path
                        if [ "$alg" == 'simclr' ]; then
                          cmd="python3 ${alg}.py  --data_name $dataset --seed $seed --corruption_rate $corruption_rate  --corruption_type $corruption_type &> ${log_path}/seed_$seed.log &"
                        else
                          cmd="python3 Solvers_BackDoor/${alg}.py  --data_name $dataset --batch_size $batch_size --seed $(($seed + 1)) --corruption_rate $corruption_rate --max_epochs $max_epochs --corruption_type $corruption_type --eps_neighbor $eps_neighbor --alpha $alpha --drop_decay_step $drop_decay_step &> ${log_path}/seed_$seed.log &"
                        fi
                        if [[ $(jobs -r -p | wc -l) -gt $N ]]; then
                        # wait only for first job
                          wait -n
                        fi
                    done
                # wait for all jobs in ith pIDs array finished
                #echo "${pids[@]}"

              done
        done
fi