## FSNet: Feasibility-Seeking Neural Network for Constrained Optimization with Guarantees

## 🚀 Installation

Install dependencies:
```bash
pip install -r requirements.txt
```

---

## 🎓 Usage

### Training

```bash
python main.py \
  --method <FSNet|penalty|adaptive_penalty|DC3|projection> \
  --prob_type <convex|nonconvex|nonsmooth_nonconvex> \
  --prob_name <qp|qcqp|socp>
```

* `--method`

  * `FSNet`              (Feasibility-Seeking Neural Network)
  * `penalty`            (Penalty method)
  * `adaptive_penalty`   (Adaptive Penalty method)
  * `DC3`                (Differentiable Convex–Concave Correction, DC3)
  * `projection`         (Projection-based method; supported for QP only)
* `--prob_type`

  * `convex`
  * `nonconvex`
  * `nonsmooth_nonconvex`
* `--prob_name`

  * `qp`   (Quadratic Program)
  * `qcqp` (Quadratically Constrained Quadratic Program)
  * `socp` (Second-Order Cone Program)

---

## 📁 Project Structure

```plain
.
├── configs/               # Configuration files (e.g. default.yaml)│ 
│   └── default.yaml
├── datasets/              # Problem instance data
│   ├── convex/
│   ├── nonconvex/
│   └── nonsmooth_nonconvex/
├── models/                # Neural network definitions
│   ├── neural_networks.py
├── utils/                 # Helper functions and trainers
│   ├── lbfgs.py
│   ├── optimization_utils.py
│   ├── trainer.py
├── results/               # Output metrics and trained models
├── main.py                # Entry point for training & evaluation
├── requirements.txt       # Python dependencies
└── README.md              # Project overview
```

---
