# SwinV2 Baselines

Training, evaluation, and wild-test utilities for SwinV2-based deepfake detectors.

## Installation

```bash
pip install -r requirements.txt
```

## Training

`train.py` now supports multiple corpora through `--dataset`:

```bash
python train.py \
  --dataset openfake \  # or semi-truths | genimage
  --output_dir $SCRATCH/swinv2-output \
  --num_epochs 5 \
  --batch_size 32 \
  --learning_rate 8e-5 \
  --num_workers 4
```

| dataset      | source                                                 | notes                                                                        |
|--------------|--------------------------------------------------------|-------------------------------------------------------------------------------|
| openfake     | HuggingFace `Anonymous460/OpenFake` (streaming)        | optional `--degradation` to mimic LAION stats; expects `../real_train_stats.npz`. |
| semi-truths  | HF to local `semi-truths/Semi-Truths` + HF `semi-truths/Semi-Truths-Evalset` | uses class-weighted loss; subsamples eval to 10k samples.                      |
| genimage     | local `genimage`                              | reads `{model}/{split}/{ai|nature}` folders; standard Trainer pipeline.       |

Training logs target a WANDB project per dataset (`SwinOpenFake`, `Semi-Truths`, `GenImage`). Adjust env vars as needed.

## Evaluation

`eval.py` mirrors the dataset selector to benchmark checkpoints:

```bash
python eval.py \
  --dataset semi-truths \
  --resume_from_checkpoint /path/to/checkpoint \
  --batch_size 64 \
  --cache_dir $SCRATCH/.cache
```

Outputs per-model accuracy/TPR/TNR plus overall AUC, F1, and accuracy. Use `--degradation` when evaluating OpenFake to match training augmentation.

## Wild Set Testing

`test_wild.py` evaluates arbitrary folder trees, it can be used for the in-the-wild small dataset as seen in the paper (default `wild/{real,fake}`):

```bash
python test_wild.py \
  --dataset_dir /data/wild \
  --subsets real fake \
  --checkpoint_path /path/to/checkpoint \
  --save_roc wild_roc.png
```

Reports subset accuracies, global metrics, and optionally saves an ROC curve.

## Checkpoints

Use the checkpoints produced per dataset/dataset configuration when running evaluation or wild tests. No direct download links are bundled here.
