#!/bin/bash

function scan_attacks () {
    model=$1
    value=$2
    atk_model=$3
    atk_value=$4
    rms0=$5
    rms1=$6
    step0=$7
    step1=$8
    config=$9
    output_dir=${10}
    sarsa_path=${11}
    
    mkdir -p ${output_dir}
    # train a sarsa model
    # python src/test.py --config-path "$config" --load-policy "$model" --load-value "$value" --load-atk-policy "$atk_model" --load-atk-value "$atk_value" --rms-path-0 "$rms0" --rms-path-1 "$rms1" --rms-step-0 "$step0" --rms-step-1 "$step1" --sarsa-model-path "$sarsa_path" --sarsa-enable --sarsa-eps 0.1 --sarsa-steps 35 --attack-method none &> "${output_dir}/sarsa_training.log" &

    # # test clean model
    # python src/test.py --config-path "$config" --load-policy "$model" --load-value "$value" --load-atk-policy "$atk_model" --load-atk-value "$atk_value" --rms-path-0 "$rms0" --rms-path-1 "$rms1" --rms-step-0 "$step0" --rms-step-1 "$step1" --attack-method none --num-actors 1 &> "${output_dir}/clean.log" &

    python src/test.py --config-path "$config" --load-policy "$model" --load-value "$value" --load-atk-policy "$atk_model" --load-atk-value "$atk_value" --rms-path-0 "$rms0" --rms-path-1 "$rms1" --rms-step-0 "$step0" --rms-step-1 "$step1" --attack-method critic --attack-eps 0.7 --num-actors 1 --attack-sarsa-network "$sarsa_path" --deterministic &> "${output_dir}/critic_0.7.log" &
    
    python src/test.py --config-path "$config" --load-policy "$model" --load-value "$value" --load-atk-policy "$atk_model" --load-atk-value "$atk_value" --rms-path-0 "$rms0" --rms-path-1 "$rms1" --rms-step-0 "$step0" --rms-step-1 "$step1" --attack-method action --attack-eps 0.7 --num-actors 1 --attack-sarsa-network "$sarsa_path" &> "${output_dir}/mad_0.7.log" &

    
    # python src/test.py --config-path "$config" --load-policy "$model" --load-value "$value" --load-atk-policy "$atk_model" --load-atk-value "$atk_value" --rms-path-0 "$rms0" --rms-path-1 "$rms1" --rms-step-0 "$step0" --rms-step-1 "$step1" --attack-method tactics --attack-eps 0.7 --num-actors 1 --attack-sarsa-network "$sarsa_path" &> "${output_dir}/tactics_0.075.log" &
        
    # python src/test.py --config-path "$config" --load-policy "$model" --load-value "$value" --load-atk-policy "$atk_model" --load-atk-value "$atk_value" --rms-path-0 "$rms0" --rms-path-1 "$rms1" --rms-step-0 "$step0" --rms-step-1 "$step1" --attack-method random --attack-eps 0.7 --num-actors 1 --attack-sarsa-network "$sarsa_path" &> "${output_dir}/random_0.7.log" &
    
    python src/test.py --config-path "$config" --load-policy "$model" --load-value "$value" --load-atk-policy "$atk_model" --load-atk-value "$atk_value" --rms-path-0 "$rms0" --rms-path-1 "$rms1" --rms-step-0 "$step0" --rms-step-1 "$step1" --attack-method sarsa --attack-eps 0.7 --num-actors 1 --attack-sarsa-network "$sarsa_path" &> "${output_dir}/sarsa_0.7.log" &
    
    python src/test.py --config-path "$config" --load-policy "$model" --load-value "$value" --load-atk-policy "$atk_model" --load-atk-value "$atk_value" --rms-path-0 "$rms0" --rms-path-1 "$rms1" --rms-step-0 "$step0" --rms-step-1 "$step1" --attack-method sarsa+action --attack-eps 0.7  --num-actors 1 --attack-sarsa-network "$sarsa_path" --attack-sarsa-action-ratio 3e-4 &> "${output_dir}/sarsa-mad_7e-1.log" &
    
    # test sarsa attacks
#    for attack_method in sarsa; do
#        echo ${attack_method}
#        for atk_eps in 0.003 0.007; do
#            echo ${atk_eps}
#            python src/test.py --config-path "$config" --load-policy "$model" --load-value "$value" --load-atk-policy "$atk_model" --load-atk-value "$atk_value" --rms-path-0 "$rms0" --rms-path-1 "$rms1" --rms-step-0 "$step0" --rms-step-1 "$step1" --attack-method ${attack_method} --attack-eps ${atk_eps} --num-actors 1 --attack-sarsa-network "$sarsa_path" &> "${output_dir}/${attack_method}_${atk_eps}.log"
      
#        done
#    done

    # test RS+MAD attacks
#    for atk_eps in 0.01 0.03; do #3e-5 3e-4 3e-3
#        echo ${atk_eps}
#        python src/test.py --config-path "$config" --load-policy "$model" --load-value "$value" --load-atk-policy "$atk_model" --load-atk-value "$atk_value" --rms-path-0 "$rms0" --rms-path-1 "$rms1" --rms-step-0 "$step0" --rms-step-1 "$step1" --attack-method sarsa+action --attack-eps ${atk_eps} --num-actors 1 --attack-sarsa-network "$sarsa_path" --attack-sarsa-action-ratio 3e-4 &> "${output_dir}/sarsa-mad_${atk_eps}.log"

#    done

        
}


