/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logging;

import cz.cvut.fel.ida.logging.Logging;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ColoredFormatter
extends Formatter {
    private static final Logger LOG = Logger.getLogger(ColoredFormatter.class.getName());
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    private long finestTimer = System.currentTimeMillis();
    private long finerTimer = System.currentTimeMillis();
    private long fineTimer = System.currentTimeMillis();
    private long infoTimer = System.currentTimeMillis();
    private long warningTimer = System.currentTimeMillis();
    private long severeTimer = System.currentTimeMillis();

    @Override
    public String format(LogRecord record) {
        StringBuilder builder = new StringBuilder();
        Level level = record.getLevel();
        long clock = record.getMillis();
        long delta = 0L;
        switch (level.getName()) {
            case "FINEST": {
                delta = clock - this.finestTimer;
                this.finestTimer = clock;
                builder.append(ANSI_YELLOW);
                break;
            }
            case "FINER": {
                delta = clock - this.finerTimer;
                this.finerTimer = clock;
                builder.append(ANSI_CYAN);
                break;
            }
            case "FINE": {
                delta = clock - this.fineTimer;
                this.fineTimer = clock;
                builder.append(ANSI_BLUE);
                break;
            }
            case "INFO": {
                delta = clock - this.infoTimer;
                this.infoTimer = clock;
                builder.append(ANSI_BLACK);
                break;
            }
            case "WARNING": {
                delta = clock - this.warningTimer;
                this.warningTimer = clock;
                builder.append(ANSI_PURPLE);
                break;
            }
            case "SEVERE": {
                delta = clock - this.severeTimer;
                this.severeTimer = clock;
                builder.append(ANSI_RED);
            }
        }
        builder.append("+").append(delta).append("ms - ");
        builder.append(Logging.calcTime(record.getMillis()));
        builder.append(" <");
        builder.append(record.getSourceClassName());
        builder.append(">");
        builder.append(" (");
        builder.append(record.getSourceMethodName());
        builder.append(")");
        builder.append(" [");
        builder.append(record.getLevel().getName());
        builder.append("]");
        builder.append(" - ");
        builder.append(record.getMessage());
        Object[] params = record.getParameters();
        if (params != null) {
            builder.append("\t");
            for (int i = 0; i < params.length; ++i) {
                builder.append(params[i]);
                if (i >= params.length - 1) continue;
                builder.append(", ");
            }
        }
        builder.append(ANSI_RESET);
        builder.append("\n");
        return builder.toString();
    }
}

