/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic;

import cz.cvut.fel.ida.logic.Literal;
import java.io.Serializable;
import java.util.logging.Logger;

public class Predicate
implements Serializable {
    private static final Logger LOG = Logger.getLogger(Predicate.class.getName());
    public String name;
    public int arity;
    public boolean special;
    private static CharSequence specialSign = "@";

    public Predicate() {
    }

    public Predicate(String predicate, int arity) {
        this.name = predicate.intern();
        this.arity = arity;
    }

    public Predicate(String from) {
        if (from.contains("/")) {
            String[] split = from.split("/");
            this.name = split[0].intern();
            try {
                this.arity = Integer.parseInt(split[1]);
            }
            catch (Exception ex) {
                LOG.severe("Cannot parse predicate arity");
            }
        } else {
            this.name = from.intern();
        }
    }

    public Predicate(Literal literal) {
        this.name = literal.predicateName();
        this.arity = literal.arity();
    }

    public static Predicate construct(String name, int arity, Boolean special) {
        Predicate predicate = new Predicate();
        predicate.name = name.intern();
        predicate.arity = arity;
        predicate.special = special != null ? special : false;
        return predicate;
    }

    public String toString() {
        return this.name + "/" + this.arity;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Predicate) {
            Predicate p = (Predicate)obj;
            if (p.name.equals(this.name) && p.arity == this.arity) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() * this.arity;
    }
}

