/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.subsumption;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.HornClause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.LogicUtils;
import cz.cvut.fel.ida.logic.Predicate;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.subsumption.CustomPredicate;
import cz.cvut.fel.ida.logic.subsumption.Matching;
import cz.cvut.fel.ida.logic.subsumption.SolutionConsumer;
import cz.cvut.fel.ida.utils.generic.Pair;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class HerbrandModel {
    private static final Logger LOG = Logger.getLogger(HerbrandModel.class.getName());
    public HerbrandMap herbrand;
    Matching matching;

    public HerbrandModel() {
        this.herbrand = new HerbrandMap();
    }

    public HerbrandModel(HerbrandMap init) {
        this.herbrand = init;
    }

    public HerbrandModel(Collection<Literal> facts) {
        this.herbrand = new HerbrandMap();
        this.populateHerbrand(facts);
    }

    public HerbrandMap inferModel(Collection<? extends Clause> clauses) {
        Pair<List<HornClause>, List<Literal>> rulesAndFacts = this.rulesAndFacts(clauses);
        return this.inferModel((Collection)rulesAndFacts.r, (Collection)rulesAndFacts.s);
    }

    public Collection<Literal> inferLiterals(Collection<HornClause> irules, Collection<Literal> facts) {
        HerbrandMap herbrandMap = this.inferModel(irules, facts);
        return Sugar.flatten(herbrandMap.getLiterals());
    }

    public HerbrandMap inferModel(Collection<HornClause> irules, Collection<Literal> facts) {
        boolean changed;
        this.populateHerbrand(facts);
        LinkedHashSet<HornClause> rules = new LinkedHashSet<HornClause>(irules);
        LinkedHashSet<Predicate> headSignatures = new LinkedHashSet<Predicate>();
        for (HornClause rule : rules) {
            headSignatures.add(rule.head().predicate());
            this.herbrand.set(rule.head().predicate(), new HashSet());
        }
        int round = 0;
        int herbrandSize0 = VectorUtils.sum(this.herbrand.sizes());
        LOG.finer("herbrand size before round " + round + " = " + herbrandSize0);
        do {
            this.matching = new Matching(Sugar.list(new Clause(Sugar.flatten(this.herbrand.values()))));
            for (Predicate predicate : headSignatures) {
                this.matching.getEngine().addCustomPredicate(new TupleNotIn(predicate, this.herbrand.get(predicate)));
            }
            Iterator iterator = rules.iterator();
            while (iterator.hasNext()) {
                Clause query;
                HornClause rule = (HornClause)iterator.next();
                Literal head = rule.head();
                PredicateSolutionConsumer solutionConsumer = new PredicateSolutionConsumer(head, this.herbrand.get(head.predicate()));
                this.matching.getEngine().addSolutionConsumer(solutionConsumer);
                if (LogicUtils.isGround(head)) {
                    query = new Clause(rule.body().literals());
                    if (this.matching.subsumption(query, 0).booleanValue()) {
                        this.herbrand.put(head.predicate(), head);
                        iterator.remove();
                    }
                } else {
                    query = new Clause(Sugar.union(rule.getNegatedLiterals(), new Literal(HerbrandModel.tupleNotInPredicateName(head.predicate()), false, head.arguments())));
                    cz.cvut.fel.ida.utils.generic.tuples.Pair<Term[], List<Term[]>> listPair = this.matching.allSubstitutions(query, 0, Integer.MAX_VALUE);
                    System.out.printf("", new Object[0]);
                }
                this.matching.getEngine().removeSolutionConsumer(solutionConsumer);
            }
            LOG.finest(() -> irules.size() + " rules grounded.");
            int herbrandSize1 = VectorUtils.sum(this.herbrand.sizes());
            LOG.finer("herbrand size after round " + round++ + " = " + herbrandSize1);
            changed = herbrandSize1 > herbrandSize0;
            herbrandSize0 = herbrandSize1;
        } while (changed);
        return this.herbrand;
    }

    public Pair<Term[], List<Term[]>> groundingSubstitutions(HornClause hornClause) {
        Clause query = new Clause(hornClause.getLiterals());
        cz.cvut.fel.ida.utils.generic.tuples.Pair<Term[], List<Term[]>> listPair = this.matching.allSubstitutions(query, 0, Integer.MAX_VALUE);
        Term[] variables = (Term[])listPair.r;
        for (int i = 0; i < variables.length; ++i) {
            variables[i].setIndexWithinSubstitution(i);
        }
        return new Pair<Term[], List<Term[]>>(variables, (List<Term[]>)listPair.s);
    }

    public void populateHerbrand(Collection<Literal> facts) {
        for (Literal groundLiteral : facts) {
            this.herbrand.put(new Predicate(groundLiteral.predicateName(), groundLiteral.arity()), groundLiteral);
        }
    }

    private Pair<List<HornClause>, List<Literal>> rulesAndFacts(Collection<? extends Clause> clauses) {
        ArrayList<Literal> groundFacts = new ArrayList<Literal>();
        ArrayList<HornClause> rest = new ArrayList<HornClause>();
        for (Clause clause : clauses) {
            if (clause.countLiterals() == 1 && LogicUtils.isGround(clause)) {
                groundFacts.add(Sugar.chooseOne(clause.literals()));
                continue;
            }
            HornClause hc = new HornClause(clause);
            if (hc.body() == null) continue;
            rest.add(hc);
        }
        return new Pair<List<HornClause>, List<Literal>>(rest, groundFacts);
    }

    private static String tupleNotInPredicateName(Predicate predicate) {
        return "@tuplenotin-" + predicate.name + "/" + predicate.arity;
    }

    public void clear() {
        this.herbrand.clear();
    }

    public static class HerbrandMap
    extends MultiMap<Predicate, Literal> {
        public Collection<Set<Literal>> getLiterals() {
            return super.values();
        }
    }

    private static class TupleNotIn
    implements CustomPredicate {
        private Set<Literal> literals;
        private String name;
        private String predicate;

        TupleNotIn(Predicate predicate, Set<Literal> literals) {
            this.predicate = predicate.name;
            this.name = HerbrandModel.tupleNotInPredicateName(predicate);
            this.literals = literals;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean isSatisfiable(Term ... arguments) {
            for (Term arg : arguments) {
                if (arg != null) continue;
                return true;
            }
            return !this.literals.contains(new Literal(this.predicate, arguments));
        }
    }

    private static class PredicateSolutionConsumer
    implements SolutionConsumer {
        Literal ruleHead;
        private Set<Literal> headGroundings;

        private PredicateSolutionConsumer(Literal head, Set<Literal> groundHeads) {
            this.ruleHead = head;
            this.headGroundings = groundHeads;
        }

        @Override
        public void solution(Term[] template, Term[] solution) {
            for (int i = 0; i < template.length; ++i) {
                template[i].setIndexWithinSubstitution(i);
            }
            this.headGroundings.add(this.ruleHead.subsCopy(solution));
        }
    }
}

