/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.exporting;

import com.google.gson.Gson;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import cz.cvut.fel.ida.utils.exporting.TextExporter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;

public class JsonExporter
extends TextExporter {
    private static final Logger LOG = Logger.getLogger(JsonExporter.class.getName());

    public JsonExporter(String ExportDir, String id) {
        super(ExportDir, id, "JSON");
    }

    public JsonExporter() {
    }

    @Override
    public void export(Exportable t) {
        if (this.repeatedExportAppend) {
            this.repairJsonCrossvalStart(this.exportFile);
        }
        this.exportLine(t.exportToJson());
        if (this.repeatedExportAppend) {
            this.repairJsonCrossvalEnd(this.exportFile);
        }
    }

    protected void repairJsonCrossvalStart(File file) {
        try {
            List<String> strings = Files.readAllLines(file.toPath());
            if (strings.isEmpty()) {
                return;
            }
            if (strings.get(0).contains("[")) {
                strings.set(strings.size() - 2, ",\n");
            } else {
                strings.add(0, "[\n");
                strings.add(",\n");
            }
            FileWriter fileWriter = new FileWriter(file, false);
            PrintWriter out = new PrintWriter(fileWriter);
            for (String string : strings) {
                out.println(string);
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void repairJsonCrossvalEnd(File file) {
        this.exportWriter.println("]\n");
        this.exportWriter.flush();
    }

    @Override
    public <I> List<I> importListFrom(Path path, Class<I> cls) {
        Class<?> aClass = Array.newInstance(cls, 1).getClass();
        try {
            String jsonArray = new String(Files.readAllBytes(path));
            List yourClassList = (List)new Gson().fromJson(jsonArray, aClass);
            return yourClassList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public <I> I importObjectFrom(Path path, Class<I> cls) {
        try {
            String json = new String(Files.readAllBytes(path));
            Object i = new Gson().fromJson(json, cls);
            return (I)i;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void delimitStart() {
        this.exportWriter.println("[");
        this.exportWriter.flush();
    }

    @Override
    public void delimitNext() {
        this.exportWriter.println(",");
        this.exportWriter.flush();
    }

    @Override
    public void delimitEnd() {
        this.exportWriter.println("{}\n]");
    }
}

