/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.generic;

import cz.cvut.fel.ida.utils.generic.Pair;
import cz.cvut.fel.ida.utils.generic.TestAnnotations;
import cz.cvut.fel.ida.utils.generic.TestLogging;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.Statistics;

public class Benchmarking {
    private static final Logger LOG = Logger.getLogger(Benchmarking.class.getName());
    private static TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private static TemporalUnit temporalUnit = ChronoUnit.MILLIS;
    private static DecimalFormat df = new DecimalFormat("0.000");

    @TestAnnotations.SlowBenchmark
    public void genericPreciesBenchmark() {
        Double coeff = TestLogging.baselinePerformanceCoeff;
        LOG.warning("TESTING NOW");
        double baselinePerformanceCoeff = Benchmarking.getBaselinePerformanceCoeff();
        Assertions.assertEquals((double)coeff, (double)baselinePerformanceCoeff, (double)0.001);
    }

    @TestAnnotations.Fast
    public void testBaseline() {
        double baselinePerformanceCoeff = Benchmarking.getBaselinePerformanceCoeff();
        System.out.println(baselinePerformanceCoeff);
    }

    public static double getBaselinePerformanceCoeff() {
        Duration reference = Duration.ofSeconds(1L);
        LOG.warning("----- benchmarking baseline performance of this computer for subsequent performance testing (runtime assertions) PLEASE PAUSE OTHER RUNNING PROCESSES -----");
        try {
            Collection<RunResult> runResults = Benchmarking.benchmarkFast(Benchmarking.class.getName() + ".baselinePerformance");
            Double meanTime = Benchmarking.getMeanTime(runResults);
            Duration realTime = Duration.of(meanTime.longValue(), temporalUnit);
            LOG.warning(realTime + " vs. expected: " + reference);
            double coeff = (double)realTime.toMillis() / (double)reference.toMillis();
            return coeff;
        }
        catch (RunnerException e) {
            e.printStackTrace();
            return 1.0;
        }
    }

    @Benchmark
    public List<Integer> baselinePerformance() {
        int tuning = 45100;
        Random random = new Random(0L);
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int i = 0; i < tuning; ++i) {
            list.add(random.nextInt());
        }
        LinkedList<Integer> out = new LinkedList<Integer>();
        for (int i = 0; i < tuning; ++i) {
            out.add((Integer)list.get(i));
        }
        return out;
    }

    public static void assertDispersionAndTime(Pair<Double, Duration> results, Double dispersion, Duration referenceTime) {
        Assertions.assertEquals((double)dispersion, (double)((Double)results.r), (double)0.01);
        LOG.warning("time taken: " + results.s);
        Assertions.assertEquals((double)((double)((Duration)results.s).toMillis() / (double)referenceTime.toMillis()), (double)1.0, (double)0.1);
    }

    public static void assertSmallRuntimeDeviation(Collection<RunResult> runResults, Duration referenceDuration, double maxDeviation) {
        double score = Benchmarking.getMeanTime(runResults);
        Duration realDuration = Duration.of(Math.round(score), temporalUnit);
        LOG.finer("real: " + realDuration.toNanos() + " vs exp: " + referenceDuration.toNanos());
        double deviation = Math.abs((double)realDuration.toNanos() / (double)referenceDuration.toNanos() - 1.0);
        LOG.warning(realDuration + " vs. expected: " + referenceDuration);
        String deviationString = df.format(deviation * 100.0) + "%";
        String maxDeviationString = df.format(maxDeviation * 100.0) + "%";
        String errorMessage = "Deviation " + deviationString + " exceeds maximum allowed deviation " + maxDeviationString;
        Assertions.assertTrue((deviation < maxDeviation ? 1 : 0) != 0, (String)errorMessage);
    }

    public static long getMeanTime(Collection<RunResult> runResults, TimeUnit requested) {
        Double meanTime = Benchmarking.getMeanTime(runResults);
        long longValue = meanTime.longValue();
        long convert = requested.convert(longValue, timeUnit);
        return convert;
    }

    public static Double getMeanTime(Collection<RunResult> runResults) {
        RunResult runResult = null;
        if (runResults.size() > 1) {
            LOG.warning("There were multiple benchmarsk run together, dunno which one to test!");
            return null;
        }
        if (runResults == null || runResults.isEmpty()) {
            LOG.warning("No benchmark results wre collected");
            return null;
        }
        runResult = runResults.iterator().next();
        Result primaryResult = runResult.getAggregatedResult().getPrimaryResult();
        Statistics statistics = primaryResult.getStatistics();
        double cvar = statistics.getStandardDeviation() / statistics.getMean();
        if (cvar > 0.5) {
            LOG.warning("Benchmark measured performance vary too much across individual runs! cvar=" + df.format(cvar * 100.0) + "%");
        }
        String scoreUnit = primaryResult.getScoreUnit();
        return statistics.getMean();
    }

    public static Collection<RunResult> benchmarkFast(String methodPath) throws RunnerException {
        Options opt = new OptionsBuilder().include(methodPath).mode(Mode.AverageTime).timeUnit(timeUnit).warmupIterations(2).measurementTime(TimeValue.milliseconds((long)1L)).measurementIterations(15).threads(1).forks(1).shouldFailOnError(true).shouldDoGC(true).build();
        Collection runResults = new Runner(opt).run();
        return runResults;
    }

    public static Collection<RunResult> benchmarkSlow(String methodPath) throws RunnerException {
        return Benchmarking.benchmarkSlow(methodPath, 1, 0);
    }

    public static Collection<RunResult> benchmarkSlow(String methodPath, int iterations, int warmupIterations) throws RunnerException {
        Options opt = new OptionsBuilder().include(methodPath).mode(Mode.SingleShotTime).timeUnit(timeUnit).warmupIterations(warmupIterations).measurementIterations(iterations).threads(1).forks(1).shouldFailOnError(true).shouldDoGC(true).build();
        Collection runResults = new Runner(opt).run();
        return runResults;
    }
}

