/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math;

import cz.cvut.fel.ida.utils.generic.tuples.Tuple;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class Combinatorics {
    private static Random random = new Random();

    private Combinatorics() {
    }

    public static <T> Tuple<T> randomCombination(List<T> list, int k) {
        return Combinatorics.randomCombination(list, k, random);
    }

    public static <T> Tuple<T> randomCombination(List<T> list, int k, Random rand) {
        if (list.size() < k) {
            throw new IllegalArgumentException("Illegal arguments: list.size() < k.");
        }
        if (k == 0) {
            return new Tuple(0);
        }
        HashSet<Integer> s = new HashSet<Integer>();
        int n = list.size();
        for (int j = n - k + 1; j <= n; ++j) {
            int t = rand.nextInt(j) + 1;
            if (!s.contains(t)) {
                s.add(t);
                continue;
            }
            s.add(j);
        }
        Tuple<T> t = new Tuple<T>(k);
        int index = 0;
        for (Integer i : s) {
            t.set(list.get(i - 1), index);
            ++index;
        }
        return t;
    }

    public static <T> Tuple<T> randomCombination(List<T> list) {
        return Combinatorics.randomCombination(list, random);
    }

    public static <T> Tuple<T> randomCombination(List<T> list, Random random) {
        ArrayList<T> ret = new ArrayList<T>();
        for (T t : list) {
            if (!random.nextBoolean()) continue;
            ret.add(t);
        }
        return new Tuple(ret);
    }

    public static <T> List<Tuple<T>> allSubsequences(List<T> list) {
        ArrayList<Tuple<T>> ret = new ArrayList<Tuple<T>>(1 << list.size());
        int listsize = list.size();
        ArrayList<T> temp = new ArrayList<T>();
        for (int i = 0; i < 1 << listsize; ++i) {
            for (int j = 0; j < listsize; ++j) {
                if (i / (1 << j) % 2 != 0) continue;
                temp.add(list.get(j));
            }
            ret.add(new Tuple(temp));
            temp.clear();
        }
        return ret;
    }

    public static <T> List<Tuple<T>> allSubsequences(List<T> list, int k) {
        ArrayList<Tuple<T>> retVal = new ArrayList<Tuple<T>>();
        List<int[]> ints = new ArrayList<int[]>();
        int n = list.size();
        for (int i = 0; i < k; ++i) {
            ints = Combinatorics.allNextSubsequences(ints, n);
        }
        for (int[] i : ints) {
            Tuple<T> t = new Tuple<T>(i.length);
            for (int j = 0; j < i.length; ++j) {
                t.set(list.get(i[j]), j);
            }
            retVal.add(t);
        }
        return retVal;
    }

    private static List<int[]> allNextSubsequences(List<int[]> list, int n) {
        ArrayList<int[]> tuples = new ArrayList<int[]>();
        if (list.isEmpty()) {
            int i = 0;
            while (i < n) {
                int[] tuple = new int[]{i++};
                tuples.add(tuple);
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                int[] oldCombination = list.get(i);
                int j = oldCombination[oldCombination.length - 1] + 1;
                while (j < n) {
                    int[] newCombination = new int[oldCombination.length + 1];
                    System.arraycopy(oldCombination, 0, newCombination, 0, oldCombination.length);
                    newCombination[oldCombination.length] = j++;
                    tuples.add(newCombination);
                }
            }
        }
        return tuples;
    }

    public static List<int[]> allPartitions(int sum, int groups) {
        return Combinatorics.allPartitions_impl(Sugar.list(new int[][]{new int[0]}), 0, sum, groups);
    }

    private static List<int[]> allPartitions_impl(List<int[]> prefix, int curGroups, int sum, int groups) {
        if (curGroups == groups) {
            return prefix;
        }
        ArrayList<int[]> extended = new ArrayList<int[]>();
        if (curGroups + 1 < groups) {
            for (int[] p : prefix) {
                int s = VectorUtils.sum(p);
                int i = 0;
                while (i <= sum - s) {
                    extended.add(VectorUtils.concat(p, new int[]{i++}));
                }
            }
        } else {
            for (int[] p : prefix) {
                int s = VectorUtils.sum(p);
                extended.add(VectorUtils.concat(p, new int[]{sum - s}));
            }
        }
        return Combinatorics.allPartitions_impl(extended, curGroups + 1, sum, groups);
    }

    public static double factorial(int n) {
        if (n < 0) {
            return -1.0;
        }
        double fact = 1.0;
        for (int i = 1; i <= n; ++i) {
            fact *= (double)i;
        }
        return fact;
    }

    public static double logFactorial(int n) {
        if (n < 0) {
            return Double.NaN;
        }
        double fact = 0.0;
        for (int i = 1; i <= n; ++i) {
            fact += Math.log(i);
        }
        return fact;
    }

    public static double binomial(int n, int k) {
        return Combinatorics.factorial(n) / (Combinatorics.factorial(k) * Combinatorics.factorial(n - k));
    }

    public static double logBinomial(int n, int k) {
        return Combinatorics.logFactorial(n) - Combinatorics.logFactorial(k) - Combinatorics.logFactorial(n - k);
    }

    public static <T> List<Tuple<T>> cartesianPower(List<T> elements, int d) {
        ArrayList<Tuple<T>> retVal = new ArrayList<Tuple<T>>();
        retVal.add(new Tuple<Object>(new Object[0]));
        for (int i = 0; i < d; ++i) {
            ArrayList<Tuple<T>> newlist = new ArrayList<Tuple<T>>();
            for (Tuple tuple : retVal) {
                for (T t : elements) {
                    newlist.add(Tuple.append(tuple, t));
                }
            }
            retVal = newlist;
        }
        return retVal;
    }

    public static <T> List<Tuple<T>> cartesianPower(List<T> elements, int d, Sugar.Fun<Tuple<T>, Boolean> test) {
        ArrayList<Tuple<T>> retVal = new ArrayList<Tuple<T>>();
        retVal.add(new Tuple<Object>(new Object[0]));
        for (int i = 0; i < d; ++i) {
            ArrayList<Tuple<T>> newlist = new ArrayList<Tuple<T>>();
            for (Tuple tuple : retVal) {
                for (T t : elements) {
                    Tuple<T> newtuple = Tuple.append(tuple, t);
                    if (!Boolean.TRUE.equals(test.apply(newtuple))) continue;
                    newlist.add(newtuple);
                }
            }
            retVal = newlist;
        }
        return retVal;
    }

    public static <T> List<Tuple<T>> cartesianProduct(List<Collection<T>> collections) {
        return Combinatorics.cartesianProduct(collections, new Sugar.Fun<Tuple<T>, Boolean>(){

            @Override
            public Boolean apply(Tuple<T> tTuple) {
                return true;
            }
        });
    }

    public static <T> List<Tuple<T>> cartesianProduct(List<Collection<T>> collections, Sugar.Fun<Tuple<T>, Boolean> test) {
        ArrayList<Tuple<T>> retVal = new ArrayList<Tuple<T>>();
        retVal.add(new Tuple<Object>(new Object[0]));
        for (int i = 0; i < collections.size(); ++i) {
            ArrayList<Tuple<T>> newList = new ArrayList<Tuple<T>>();
            for (Tuple tuple : retVal) {
                for (T t : collections.get(i)) {
                    Tuple<T> newTuple = Tuple.append(tuple, t);
                    if (!Boolean.TRUE.equals(test.apply(newTuple))) continue;
                    newList.add(newTuple);
                }
            }
            retVal = newList;
        }
        return retVal;
    }

    public static double binomialProbability(int observed, double p, int n) {
        return Math.exp(Combinatorics.logBinomialProbability(observed, p, n));
    }

    public static double logBinomialProbability(int observed, double p, int n) {
        return Combinatorics.logBinomial(n, observed) + (double)observed * Math.log(p) + (double)(n - observed) * Math.log(1.0 - p);
    }

    public static void main(String[] args) {
        System.out.println(Combinatorics.cartesianProduct(Sugar.list(Sugar.list("a", "b", "c"), Sugar.list("d", "e"))));
    }
}

