/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import cz.cvut.fel.ida.utils.math.collections.IntegerSet;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IntegerMultiMap<R> {
    private Map<R, IntegerSet> map = new HashMap<R, IntegerSet>();

    public static <R> IntegerMultiMap createIntegerMultiMap(MultiMap<R, Integer> multiMap) {
        IntegerMultiMap<R> ib = new IntegerMultiMap<R>();
        for (Map.Entry<R, Set<Integer>> entry : multiMap.entrySet()) {
            ib.add(entry.getKey(), IntegerSet.createIntegerSet(entry.getValue()));
        }
        return ib;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(R key) {
        return this.map.containsKey(key);
    }

    public IntegerSet get(R key) {
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        return IntegerSet.emptySet;
    }

    public void add(R key, IntegerSet value) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, value);
        } else {
            this.map.put(key, IntegerSet.union(value, this.map.get(key)));
        }
    }

    public void remove(R key) {
        this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<R> keySet() {
        return this.map.keySet();
    }

    public Collection<IntegerSet> values() {
        return this.map.values();
    }

    public Set<Map.Entry<R, IntegerSet>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MultiMap) {
            return this.map.equals(((IntegerMultiMap)o).map);
        }
        return false;
    }
}

