/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions;

import cz.cvut.fel.ida.algebra.functions.specific.Average;
import cz.cvut.fel.ida.algebra.functions.specific.Maximum;
import cz.cvut.fel.ida.algebra.functions.specific.Sum;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.List;
import java.util.logging.Logger;

public abstract class Aggregation
implements Exportable {
    private static final Logger LOG = Logger.getLogger(Aggregation.class.getName());

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public abstract Aggregation replaceWithSingleton();

    public abstract Value evaluate(List<Value> var1);

    public abstract Value differentiate(List<Value> var1);

    public static Aggregation getAggregation(Settings.AggregationFcn aggregationFcn) {
        switch (aggregationFcn) {
            case AVG: {
                return Singletons.average;
            }
            case MAX: {
                return Singletons.maximum;
            }
            case SUM: {
                return Singletons.sum;
            }
        }
        LOG.severe("Unimplemented aggregation function");
        return null;
    }

    public static Aggregation parseFrom(String agg) {
        switch (agg) {
            case "avg": {
                return Singletons.average;
            }
            case "max": {
                return Singletons.maximum;
            }
            case "sum": {
                return Singletons.sum;
            }
        }
        LOG.severe("Unimplemented aggregation function");
        return null;
    }

    public Pair<Double, Double> getSaturationRange() {
        return null;
    }

    public abstract boolean isInputSymmetric();

    public static interface State
    extends Exportable {
        public void cumulate(Value var1);

        public void invalidate();

        public int[] getInputMask();

        public Value gradient();

        public Value evaluate();
    }

    public static class Singletons {
        public static Average average = new Average();
        public static Maximum maximum = new Maximum();
        public static Sum sum = new Sum();
    }
}

