/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions.specific;

import cz.cvut.fel.ida.algebra.functions.Activation;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.function.Function;
import java.util.logging.Logger;

public class Sigmoid
extends Activation {
    private static final Logger LOG = Logger.getLogger(Sigmoid.class.getName());
    private static final Function<Double, Double> logist = in -> in > 100.0 ? 1.0 : (in < -100.0 ? 0.0 : 1.0 / (1.0 + Math.exp(-in.doubleValue())));
    private static final Function<Double, Double> diffLogist = in -> {
        if (in > 100.0 || in < -100.0) {
            return 0.0;
        }
        double sigm = 1.0 / (1.0 + Math.exp(-in.doubleValue()));
        return sigm * (1.0 - sigm);
    };

    @Override
    public String getName() {
        return "Sigmoid";
    }

    public Sigmoid() {
        super(logist, diffLogist);
    }

    @Override
    public Sigmoid replaceWithSingleton() {
        return Activation.Singletons.sigmoid;
    }

    @Override
    public Pair<Double, Double> getSaturationRange() {
        return new Pair<Double, Double>(0.01, 0.99);
    }
}

