/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.utils.metadata;

import cz.cvut.fel.ida.algebra.utils.metadata.Metadata;
import cz.cvut.fel.ida.algebra.utils.metadata.Parameter;
import cz.cvut.fel.ida.algebra.utils.metadata.ParameterValue;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.setup.Settings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class WeightMetadata
extends Metadata<Weight> {
    private static final Logger LOG = Logger.getLogger(WeightMetadata.class.getName());

    public WeightMetadata(Value initValue) {
        this.metadata = new LinkedHashMap();
        this.addValidateMetadatum("initValue", initValue);
    }

    public WeightMetadata(Settings settings, Map<String, Object> stringObjectMap) {
        super(settings, stringObjectMap);
    }

    @Override
    public boolean addValidateMetadatum(String parameterText, Object value) {
        Parameter parameter = new Parameter(parameterText);
        ParameterValue parameterValue = new ParameterValue(value);
        boolean valid = false;
        if (parameter.type == Parameter.Type.VALUE && parameterValue.type == ParameterValue.Type.VALUE) {
            valid = true;
        }
        if (valid) {
            this.metadata.put(parameter, parameterValue);
        }
        return valid;
    }

    @Override
    public void applyTo(Weight object) {
        this.metadata.forEach((param, value) -> this.apply(object, (Parameter)param, (ParameterValue)value));
    }

    private void apply(Weight weight, Parameter param, ParameterValue value) {
        if (param.type == Parameter.Type.VALUE) {
            weight.value = (Value)value.value;
        }
    }

    public void addAll(WeightMetadata weightMetadata) {
        if (this.metadata == null) {
            this.metadata = weightMetadata.metadata;
        } else {
            this.metadata.putAll(weightMetadata.metadata);
        }
    }
}

