/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.learning.results;

import cz.cvut.fel.ida.learning.results.Results;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.LinkedList;
import java.util.List;

public class Progress
implements Exportable<Progress> {
    transient Restart currentRestart;
    public transient List<Restart> restarts = new LinkedList<Restart>();
    public TrainVal bestResults;

    public void addOnlineResults(Results next) {
        Results results;
        if (!this.currentRestart.onlineTrainingResults.isEmpty() && (results = this.currentRestart.onlineTrainingResults.get(this.currentRestart.onlineTrainingResults.size() - 1)) != this.bestResults.training) {
            results.evaluations = null;
        }
        this.currentRestart.onlineTrainingResults.add(next);
    }

    public void addTrueResults(Results training, Results validation) {
        Results results;
        if (!this.currentRestart.trueTrainingResults.isEmpty() && (results = this.currentRestart.trueTrainingResults.get(this.currentRestart.trueTrainingResults.size() - 1)) != this.bestResults.training) {
            results.evaluations = null;
        }
        this.currentRestart.trueTrainingResults.add(training);
        if (!this.currentRestart.validationResults.isEmpty() && (results = this.currentRestart.validationResults.get(this.currentRestart.validationResults.size() - 1)) != this.bestResults.validation) {
            results.evaluations = null;
        }
        this.currentRestart.validationResults.add(validation);
    }

    public void nextRestart() {
        this.currentRestart = new Restart();
        this.restarts.add(this.currentRestart);
    }

    public int getEpochCount() {
        return this.currentRestart.onlineTrainingResults.size();
    }

    public Results getCurrentOnlineTrainingResults() {
        return this.currentRestart.onlineTrainingResults.get(this.currentRestart.onlineTrainingResults.size() - 1);
    }

    public TrainVal getLastTrueResults() {
        return new TrainVal(this.currentRestart.trueTrainingResults.get(this.currentRestart.trueTrainingResults.size() - 1), this.currentRestart.validationResults.get(this.currentRestart.validationResults.size() - 1));
    }

    public static class TrainVal
    implements Exportable<TrainVal> {
        public Results training;
        public Results validation;

        public TrainVal(Results train, Results validation) {
            this.training = train;
            this.validation = validation;
        }

        public boolean betterThan(TrainVal other, boolean preferBestTrainingNotvalidation, Settings.ModelSelection criterion) {
            if (other.validation.evaluations != null && !other.validation.evaluations.isEmpty() && !preferBestTrainingNotvalidation) {
                return this.validation.betterThan(other.validation, criterion);
            }
            return this.training.betterThan(other.training, criterion);
        }
    }

    public class Restart {
        public List<Results> onlineTrainingResults = new LinkedList<Results>();
        public List<Results> trueTrainingResults = new LinkedList<Results>();
        public List<Results> validationResults = new LinkedList<Results>();
    }
}

