/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.learning.results;

import com.sun.istack.internal.NotNull;
import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.functions.specific.Average;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.learning.results.ClassificationResults;
import cz.cvut.fel.ida.learning.results.DetailedClassificationResults;
import cz.cvut.fel.ida.learning.results.RegressionResults;
import cz.cvut.fel.ida.learning.results.Result;
import cz.cvut.fel.ida.learning.results.VoidResults;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public abstract class Results
implements Exportable<Results> {
    private static final Logger LOG = Logger.getLogger(Results.class.getName());
    transient Settings settings;
    @Deprecated
    public boolean evaluatedOnline = true;
    public transient List<Result> evaluations;
    Aggregation aggregationFcn;
    public Value error;

    public Results(@NotNull List<Result> evaluations, Settings settings) {
        this.settings = settings;
        this.evaluations = evaluations;
        this.aggregationFcn = Results.getAggregation(settings);
        if (!evaluations.isEmpty()) {
            this.recalculate();
        }
    }

    public void addResult(Result result) {
        this.evaluations.add(result);
    }

    public String toString() {
        return this.aggregationFcn.toString() + "-error= " + this.error.toString();
    }

    public abstract boolean recalculate();

    public abstract boolean betterThan(Results var1, Settings.ModelSelection var2);

    protected Results(Value meanError) {
        this.error = meanError;
    }

    public StringBuilder printOutputs(boolean sortByIndex) {
        if (sortByIndex) {
            this.evaluations.sort(new Comparator<Result>(){

                @Override
                public int compare(Result o1, Result o2) {
                    return Integer.compare(o1.position, o2.position);
                }
            });
        } else {
            Collections.sort(this.evaluations);
        }
        StringBuilder sb = new StringBuilder();
        for (Result evaluation : this.evaluations) {
            sb.append(evaluation.sampleId);
            sb.append(" , output: " + evaluation.getOutput().toDetailedString());
            if (evaluation.getTarget() != null) {
                sb.append(" , target: " + evaluation.getTarget());
            }
            sb.append("\n");
        }
        return sb;
    }

    private static Aggregation getAggregation(Settings settings) {
        if (settings.errorAggregationFcn == Settings.AggregationFcn.AVG) {
            return new Average();
        }
        LOG.severe("Unsupported errorAggregationFcn.");
        return null;
    }

    public abstract String toString(Settings var1);

    public boolean isEmpty() {
        return this.evaluations.isEmpty();
    }

    private static class ClassificationFactory
    extends Factory {
        public ClassificationFactory(Settings aggregation) {
            super(aggregation);
        }

        @Override
        public Results createFrom(List<Result> outputs) {
            ClassificationResults classificationResults = new ClassificationResults(outputs, this.settings);
            return classificationResults;
        }
    }

    private static class DetailedClassificationFactory
    extends Factory {
        public DetailedClassificationFactory(Settings aggregation) {
            super(aggregation);
        }

        @Override
        public Results createFrom(List<Result> outputs) {
            DetailedClassificationResults detailedClassificationResults = new DetailedClassificationResults(outputs, this.settings);
            return detailedClassificationResults;
        }
    }

    private static class RegressionFactory
    extends Factory {
        public RegressionFactory(Settings aggregation) {
            super(aggregation);
        }

        @Override
        public Results createFrom(List<Result> outputs) {
            RegressionResults regressionResults = new RegressionResults(outputs, this.settings);
            return regressionResults;
        }
    }

    private static class VoidFactory
    extends Factory {
        public VoidFactory(Settings settings) {
            super(settings);
        }

        @Override
        public Results createFrom(List<Result> outputs) {
            VoidResults regressionResults = new VoidResults(outputs, this.settings);
            return regressionResults;
        }
    }

    public static abstract class Factory {
        Settings settings;

        public Factory(Settings settings) {
            this.settings = settings;
        }

        public static Factory getFrom(Settings settings) {
            if (settings.regression) {
                return new RegressionFactory(settings);
            }
            if (settings.detailedResults) {
                return new DetailedClassificationFactory(settings);
            }
            return new ClassificationFactory(settings);
        }

        public abstract Results createFrom(List<Result> var1);
    }
}

