/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic;

import cz.cvut.fel.ida.logic.Constant;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.Variable;
import java.util.Map;

public class Function
implements Term {
    private int hashCode = -1;
    private String toString;
    private Term[] arguments;
    private String functionName;

    public Function(String functionName, int arity) {
        this.functionName = functionName;
        this.arguments = new Term[arity];
    }

    public Function(String functionName, Term ... arguments) {
        this(functionName, arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            this.set(arguments[i], i);
        }
    }

    public Term get(int index) {
        return this.arguments[index];
    }

    public void set(Term term, int index) {
        this.arguments[index] = term;
        this.toString = null;
        this.hashCode = -1;
    }

    @Override
    public String name() {
        return this.functionName;
    }

    @Override
    public String type() {
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof Function) {
            Function f = (Function)o;
            return this.toString().equals(f.toString());
        }
        return false;
    }

    public int arity() {
        return this.arguments.length;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.functionName);
            sb.append("(");
            for (int i = 0; i < this.arguments.length; ++i) {
                sb.append(this.arguments[i].toString());
                if (i >= this.arguments.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            this.toString = sb.toString();
        }
        return this.toString;
    }

    public Literal toLiteral() {
        String name = this.functionName;
        boolean negated = name.startsWith("!");
        if (negated) {
            name = name.substring(1);
        }
        Literal l = new Literal(name, negated, this.arguments.length);
        for (int i = 0; i < this.arguments.length; ++i) {
            l.set(this.arguments[i], i);
        }
        return l;
    }

    public static Function parseFunction(String str, Map<Variable, Variable> variables, Map<Constant, Constant> constants) {
        Literal fLit = Literal.parseLiteral(str, variables, constants);
        Function f = new Function(fLit.predicateName(), fLit.arity());
        for (int i = 0; i < fLit.arity(); ++i) {
            f.set(fLit.get(i), i);
        }
        return f;
    }
}

