/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import cz.cvut.fel.ida.algebra.functions.Activation;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Predicate;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.constructs.WeightedPredicate;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.List;
import java.util.logging.Logger;

public class Atom
implements Exportable {
    private static final Logger LOG = Logger.getLogger(Atom.class.getName());
    @NotNull
    public WeightedPredicate offsettedPredicate;
    @NotNull
    public Literal literal;
    @Nullable
    public Activation activation;
    @Nullable
    public String originalString;
    public boolean dropout;

    public Atom(WeightedPredicate weightedPredicate, List<Term> terms, boolean negated) {
        if (weightedPredicate.predicate.arity != terms.size()) {
            LOG.severe("Predicate arity and terms size mismatch while creating an Atom");
        }
        this.offsettedPredicate = weightedPredicate;
        this.literal = new Literal(weightedPredicate.predicate, negated, terms);
        this.activation = this.offsettedPredicate.activation;
    }

    public Atom(Atom another) {
        this.offsettedPredicate = another.offsettedPredicate;
        this.literal = another.literal;
        this.activation = another.activation;
        this.originalString = another.originalString;
    }

    public Predicate getPredicate() {
        return this.literal.predicate();
    }

    public WeightedPredicate getOffsettedPredicate() {
        return this.offsettedPredicate;
    }

    public boolean isNegated() {
        return this.literal.isNegated();
    }

    public Literal getLiteral() {
        return this.literal;
    }

    public int hashCode() {
        return this.literal.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Atom)) {
            return false;
        }
        Atom other = (Atom)obj;
        return this.literal.equals(other.literal);
    }

    public String toString() {
        return this.literal.toString();
    }

    public Activation getActivation() {
        if (this.activation != null) {
            return this.activation;
        }
        if (this.offsettedPredicate.activation != null) {
            return this.offsettedPredicate.activation;
        }
        return null;
    }
}

