/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.building.factories;

import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class WeightFactory
implements Exportable {
    private static final Logger LOG = Logger.getLogger(WeightFactory.class.getName());
    private int index = 0;
    public String genericName = "w";
    private Map<String, Weight> str2weight;
    private Map<Weight, Weight> weight2weight;

    public WeightFactory() {
        this.str2weight = new HashMap<String, Weight>();
        this.weight2weight = new HashMap<Weight, Weight>();
    }

    public WeightFactory(Collection<Weight> weights) {
        this.str2weight = weights.stream().collect(Collectors.toMap(Weight::toString, Function.identity()));
        this.weight2weight = weights.stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
    }

    public Weight construct(String from) {
        Weight result = this.str2weight.get(from);
        if (result == null) {
            result = new Weight(this.index++, from, null, false, false);
            this.str2weight.put(from, result);
            this.weight2weight.put(result, result);
        }
        return result;
    }

    public Weight construct(Weight from) {
        Weight result = this.weight2weight.get(from);
        if (result != null) {
            this.str2weight.put(result.toString(), result);
            this.weight2weight.put(result, result);
        }
        return from;
    }

    public Weight construct(String name, Value value, boolean fixed, boolean isInitialized) {
        if (value == null) {
            return null;
        }
        Weight result = this.str2weight.get(name);
        if (result == null) {
            result = new Weight(this.index++, name, value, fixed, isInitialized);
            this.str2weight.put(name, result);
            this.weight2weight.put(result, result);
        }
        return result;
    }

    public Weight construct(Value value, boolean fixed, boolean isInitialized) {
        if (value == null) {
            return null;
        }
        Weight result = new Weight(this.index, this.genericName + this.index++, value, fixed, isInitialized);
        return result;
    }

    public Weight mergeWeights(Aggregation aggregationFcn, Weight a, Weight b) {
        if ((a.isShared || b.isShared) && !a.equals(b)) {
            LOG.severe("Trying to merge two different shared weights" + a + " != " + b);
        }
        return new Weight(this.index++, a.name + b.name, aggregationFcn.evaluate(Arrays.asList(a.value, b.value)), a.isFixed && b.isFixed, false);
    }
}

