/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.template.metadata;

import cz.cvut.fel.ida.algebra.functions.Activation;
import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.functions.CrossProduct;
import cz.cvut.fel.ida.algebra.utils.metadata.Metadata;
import cz.cvut.fel.ida.algebra.utils.metadata.Parameter;
import cz.cvut.fel.ida.algebra.utils.metadata.ParameterValue;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.setup.Settings;
import java.util.Map;
import java.util.logging.Logger;

public class RuleMetadata
extends Metadata<WeightedRule> {
    private static final Logger LOG = Logger.getLogger(RuleMetadata.class.getName());

    public RuleMetadata(Settings settings, Map<String, Object> stringObjectMap) {
        super(settings, stringObjectMap);
    }

    @Override
    public boolean addValidateMetadatum(String parameterText, Object value) {
        Aggregation aggregation;
        Parameter parameter = new Parameter(parameterText);
        ParameterValue parameterValue = new ParameterValue(value);
        boolean valid = false;
        if (parameter.type == Parameter.Type.OFFSET && parameterValue.type == ParameterValue.Type.VALUE) {
            valid = true;
        } else if (parameter.type == Parameter.Type.LEARNABLE && parameterValue.type == ParameterValue.Type.BOOLEAN) {
            valid = true;
        } else if (parameter.type == Parameter.Type.ACTIVATION && parameterValue.type == ParameterValue.Type.STRING) {
            Aggregation aggregation2 = Activation.parseActivation(parameterValue.stringValue);
            if (aggregation2 != null) {
                valid = true;
                parameterValue.value = aggregation2;
            }
        } else if (parameter.type == Parameter.Type.AGGREGATION && parameterValue.type == ParameterValue.Type.STRING && (aggregation = Aggregation.parseFrom(parameterValue.stringValue)) != null) {
            valid = true;
            parameterValue.value = aggregation;
        }
        if (valid) {
            this.metadata.put(parameter, parameterValue);
        }
        return true;
    }

    @Override
    public void applyTo(WeightedRule object) {
        this.metadata.forEach((param, value) -> this.apply(object, (Parameter)param, (ParameterValue)value));
    }

    private void apply(WeightedRule rule, Parameter param, ParameterValue value) {
        if (param.type == Parameter.Type.ACTIVATION) {
            if (value.value instanceof CrossProduct) {
                rule.setActivationFcn(rule.getActivationFcn() != null ? new CrossProduct(rule.getActivationFcn()) : new CrossProduct(Activation.getActivationFunction(this.settings.ruleNeuronActivation)));
            }
            rule.setActivationFcn((Activation)value.value);
        }
        if (param.type == Parameter.Type.AGGREGATION) {
            rule.setAggregationFcn((Aggregation)value.value);
        }
    }
}

