/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.template.types;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Predicate;
import cz.cvut.fel.ida.logic.constructs.example.QueryAtom;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.logic.constructs.template.components.BodyAtom;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.logic.subsumption.Matching;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class GraphTemplate
extends Template {
    private static final Logger LOG = Logger.getLogger(GraphTemplate.class.getName());
    public transient Map<Literal, Set<WeightedRule>> atom2rules;
    transient Set<Literal> closedAtoms;
    transient Set<Literal> openAtoms;

    public GraphTemplate() {
        this.atom2rules = new HashMap<Literal, Set<WeightedRule>>();
    }

    public GraphTemplate(Template template) {
        super(template);
        HashMap<Predicate, List> predicate2heads = new HashMap<Predicate, List>();
        this.atom2rules = new HashMap<Literal, Set<WeightedRule>>();
        this.closedAtoms = new HashSet<Literal>();
        this.openAtoms = new HashSet<Literal>();
        Clause clause = new Clause(template.facts.stream().map(f -> f.literal).collect(Collectors.toList()));
        Matching matching = new Matching(Collections.singletonList(clause));
        for (WeightedRule weightedRule : template.rules) {
            List list = predicate2heads.computeIfAbsent(weightedRule.getHead().literal.predicate(), k -> new ArrayList());
            list.add(weightedRule);
            Set list2 = this.atom2rules.computeIfAbsent(weightedRule.getHead().literal, k -> new HashSet());
            list2.add(weightedRule);
        }
        for (Map.Entry entry : predicate2heads.entrySet()) {
            for (WeightedRule anyRule : (List)entry.getValue()) {
                for (BodyAtom bodyAtom : anyRule.getBody()) {
                    List possibleRules = (List)predicate2heads.get(bodyAtom.literal.predicate());
                    boolean hasChildren = false;
                    if (possibleRules != null) {
                        for (WeightedRule possibleRule : possibleRules) {
                            if (!matching.subsumption(new Clause(possibleRule.getHead().literal), new Clause(bodyAtom.literal)).booleanValue()) continue;
                            hasChildren = true;
                            Set rules4atom = this.atom2rules.computeIfAbsent(bodyAtom.literal, k -> new HashSet());
                            rules4atom.add(possibleRule);
                        }
                    }
                    if (hasChildren) continue;
                    if (matching.subsumption(new Clause(bodyAtom.literal), 0).booleanValue()) {
                        this.closedAtoms.add(bodyAtom.literal);
                        continue;
                    }
                    this.openAtoms.add(bodyAtom.literal);
                }
            }
        }
    }

    public GraphTemplate(GraphTemplate template) {
        super(template);
        this.atom2rules = template.atom2rules;
        this.closedAtoms = template.closedAtoms;
        this.openAtoms = template.openAtoms;
    }

    @Override
    public GraphTemplate prune(QueryAtom queryAtom) {
        GraphTemplate pruned = new GraphTemplate(this);
        pruned.rules = new LinkedHashSet();
        this.recursePrune(queryAtom.headAtom.literal, pruned.rules);
        return pruned;
    }

    private void recursePrune(Literal head, LinkedHashSet<WeightedRule> rules) {
        Set<WeightedRule> childrenRules = this.atom2rules.get(head);
        if (childrenRules == null) {
            return;
        }
        for (WeightedRule rule : childrenRules) {
            rules.add(rule);
            for (BodyAtom bodyAtom : rule.getBody()) {
                this.recursePrune(bodyAtom.literal, rules);
            }
        }
    }
}

