/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.subsumption;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Constant;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.LogicUtils;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.Variable;
import cz.cvut.fel.ida.logic.special.IsoClauseWrapper;
import cz.cvut.fel.ida.logic.subsumption.Matching;
import cz.cvut.fel.ida.logic.subsumption.MaxCardXorConstraint;
import cz.cvut.fel.ida.logic.subsumption.SubsumptionEngineJ2;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.generic.tuples.Tuple;
import cz.cvut.fel.ida.utils.math.Cache;
import cz.cvut.fel.ida.utils.math.Combinatorics;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class ApproximateSubsetCounter {
    public static boolean verbose = true;
    private static final double log2 = Math.log(2.0);
    private double epsilon = 0.1;
    private double delta = 0.1;
    private double simpleSamplingRelativeError = 0.01;
    private double simpleSamplingDelta = 0.1;
    private int numTries = -1;
    private Matching matching;
    private SubsumptionEngineJ2.ClauseE clauseE;
    private Clause db;
    private Random random = new Random(this.getClass().getName().hashCode());
    private static final Object cacheLock = new Object();
    private static Cache<Pair<Set<IsoClauseWrapper>, Integer>, Double> cache = new Cache();

    public ApproximateSubsetCounter(Clause db) {
        this.db = db;
        this.matching = new Matching(Sugar.list(db));
        this.clauseE = this.matching.examples().get(0);
    }

    public ApproximateSubsetCounter(Clause db, double epsilon, double delta) {
        this(db);
        this.epsilon = epsilon;
        this.delta = delta;
    }

    public ApproximateSubsetCounter(Clause db, double epsilon, int numTries) {
        this(db);
        this.epsilon = epsilon;
        this.numTries = numTries;
    }

    public double logApproxCount(Clause query, int maxCard) {
        return this.logApproxCount(Sugar.list(query), maxCard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double logApproxCount(List<Clause> orOfQueries, int maxCard) {
        double retVal;
        Pair representative = new Pair(new HashSet(), maxCard);
        for (Clause c : orOfQueries) {
            ((Set)representative.r).add(new IsoClauseWrapper(c));
        }
        Object object = cacheLock;
        synchronized (object) {
            Double d = cache.get(representative);
            if (d != null) {
                return d;
            }
        }
        Double estimate = this.logApproxBySimpleSampling(orOfQueries, maxCard, 10000);
        if (estimate != null) {
            retVal = estimate;
        } else {
            int maxExact = 100000;
            int count1 = this.count(orOfQueries, maxCard, maxExact);
            if (count1 >= maxExact) {
                if (verbose) {
                    System.out.println("warning: using xor-based sampling (slow).");
                }
                retVal = this.approxMC2(orOfQueries, this.clauseE, maxCard);
            } else {
                retVal = Math.log(count1) / log2;
            }
        }
        Object object2 = cacheLock;
        synchronized (object2) {
            cache.put(representative, retVal);
        }
        return retVal;
    }

    private Double logApproxBySimpleSampling(List<Clause> orOfQueries, int maxCard, int numSamples) {
        double hits = 0.0;
        List constants = Sugar.listFromCollections(LogicUtils.constants(this.db));
        double tries = 0.0;
        for (int i = 0; i < numSamples; ++i) {
            Tuple sample = Combinatorics.randomCombination(constants, maxCard, this.random);
            tries += 1.0;
            Clause e = new Clause(Sugar.union(LogicUtils.induced(this.db, sample.toSet()).literals(), new Literal("", sample.toList())));
            for (Clause q : orOfQueries) {
                if (!this.matching.subsumption(q, e).booleanValue()) continue;
                hits += 1.0;
                break;
            }
            if (!(hits > 0.0)) continue;
            double pHat = hits / tries;
            double lower = pHat * (1.0 - this.simpleSamplingRelativeError);
            double higher = pHat * (1.0 + this.simpleSamplingRelativeError);
            boolean enough = true;
            if (lower > 0.0 && Combinatorics.logBinomialProbability((int)hits, lower, (int)tries) > Math.log(this.simpleSamplingDelta) || higher < 1.0 && Combinatorics.logBinomialProbability((int)hits, higher, (int)tries) > Math.log(this.simpleSamplingDelta)) continue;
            return (Math.log(hits) - Math.log(tries) + Combinatorics.logBinomial(constants.size(), maxCard)) / Math.log(2.0);
        }
        return null;
    }

    public int count(List<Clause> orOfQueries, int maxCard, int maxCount) {
        return this.allImages(orOfQueries, maxCard, maxCount).size();
    }

    public int count(Clause query, int maxCard, int maxCount) {
        return this.allImages(query, this.clauseE, maxCard, maxCount, (boolean[][])null, null).size();
    }

    public Set<Set<Term>> allImages(Clause query, int maxCard) {
        return this.allImages(query, maxCard, Integer.MAX_VALUE);
    }

    public Set<Set<Term>> allImages(Clause query, int maxCard, int maxCount) {
        return this.allImages(query, this.clauseE, maxCard, maxCount, (boolean[][])null, null);
    }

    public Set<Set<Term>> allImages(List<Clause> orOfQueries, int maxCard, int maxCount) {
        return this.allImages(orOfQueries, this.clauseE, maxCard, maxCount, (boolean[][])null, null);
    }

    private double approxMC2(Clause query, SubsumptionEngineJ2.ClauseE clauseE, int maxCard) {
        return Sugar.println(this.approxMC2(Sugar.list(query), clauseE, maxCard));
    }

    private double approxMC2(List<Clause> orOfQueries, SubsumptionEngineJ2.ClauseE clauseE, int maxCard) {
        double threshold = 1.0 + 9.84 * (1.0 + this.epsilon / (1.0 + this.epsilon)) * Sugar.square(1.0 + 1.0 / this.epsilon);
        Set<Set<Term>> imgs = this.allImages(orOfQueries, clauseE, maxCard, (int)threshold, (boolean[][])null, null);
        if (imgs.size() < (int)threshold) {
            return Math.log(imgs.size()) / log2;
        }
        double t = this.numTries == -1 ? Math.ceil(17.0 * Math.log(2.0 / this.delta) / log2) : (double)this.numTries;
        int logNCells = 1;
        ArrayList<Double> logCounts = new ArrayList<Double>();
        int i = 0;
        while ((double)i < t) {
            Pair<Double, Double> p = this.approxMC2Core(orOfQueries, clauseE, maxCard, (int)threshold, logNCells);
            if (p != null) {
                logCounts.add((Double)p.r + Math.log((Double)p.s) / log2);
                logNCells = ((Double)p.r).intValue();
            }
            ++i;
        }
        if (logCounts.isEmpty()) {
            return Double.NaN;
        }
        double[] logCountsArray = VectorUtils.toDoubleArray(logCounts);
        Arrays.sort(logCountsArray);
        return logCountsArray[logCountsArray.length / 2];
    }

    private Pair<Double, Double> approxMC2Core(List<Clause> orOfQueries, SubsumptionEngineJ2.ClauseE clauseE, int maxCard, int threshold, int logPrevNCells) {
        int numTerms = clauseE.allTerms().size();
        int numRows = (int)Math.ceil(Combinatorics.logBinomial(numTerms, maxCard) / log2);
        boolean[][] left = new boolean[numRows][];
        boolean[] right = new boolean[numRows];
        for (int i = 0; i < left.length; ++i) {
            left[i] = VectorUtils.randomBooleanVector(numTerms, this.random);
            right[i] = this.random.nextBoolean();
        }
        Set<Set<Term>> images = this.allImages(orOfQueries, clauseE, maxCard, threshold, (boolean[][])left, right);
        if (images.size() >= threshold) {
            return null;
        }
        int m = this.logSatSearch(orOfQueries, clauseE, maxCard, threshold, left, right, logPrevNCells);
        boolean[][] leftM = new boolean[m][];
        System.arraycopy(left, 0, leftM, 0, m);
        boolean[] rightM = new boolean[m];
        System.arraycopy(right, 0, rightM, 0, m);
        images = this.allImages(orOfQueries, clauseE, maxCard, threshold, (boolean[][])leftM, rightM);
        return new Pair<Double, Double>(Double.valueOf(m), Double.valueOf(images.size()));
    }

    private int logSatSearch(List<Clause> orOfQueries, SubsumptionEngineJ2.ClauseE clauseE, int maxCard, int threshold, boolean[][] left, boolean[] right, int mPrev) {
        int loIndex = 0;
        int hiIndex = right.length - 1;
        int m = mPrev;
        Boolean[] bigCell = new Boolean[right.length];
        bigCell[0] = Boolean.TRUE;
        bigCell[1] = Boolean.FALSE;
        while (true) {
            int i;
            boolean[][] leftM = new boolean[m][];
            System.arraycopy(left, 0, leftM, 0, m);
            boolean[] rightM = new boolean[m];
            System.arraycopy(right, 0, rightM, 0, m);
            Set<Set<Term>> images = this.allImages(orOfQueries, clauseE, maxCard, threshold, (boolean[][])leftM, rightM);
            if (images.size() >= threshold) {
                if (bigCell[m + 1] == Boolean.FALSE) {
                    return m + 1;
                }
                for (i = 1; i <= m; ++i) {
                    bigCell[i] = Boolean.TRUE;
                }
                loIndex = m;
                if (Math.abs(m - mPrev) < 3) {
                    ++m;
                    continue;
                }
                if (2 * m < bigCell.length) {
                    m = 2 * m;
                    continue;
                }
                m = (m + hiIndex) / 2;
                continue;
            }
            if (bigCell[m - 1] == Boolean.TRUE) {
                return m;
            }
            for (i = m; i < bigCell.length; ++i) {
                bigCell[i] = Boolean.FALSE;
            }
            hiIndex = m;
            if (Math.abs(m - mPrev) < 3) {
                --m;
                continue;
            }
            m = (m + loIndex) / 2;
        }
    }

    private Set<Set<Term>> allImages(List<Clause> orOfQueries, SubsumptionEngineJ2.ClauseE clauseE, int maxCard, int maxCount, boolean[][] xorLeft, boolean[] xorRight) {
        HashSet<Set<Term>> retVal = new HashSet<Set<Term>>();
        for (Clause query : orOfQueries) {
            retVal.addAll(this.allImages(query, clauseE, maxCard, maxCount, xorLeft, xorRight));
            if (retVal.size() < maxCount) continue;
            break;
        }
        return retVal;
    }

    private Set<Set<Term>> allImages(Clause query, SubsumptionEngineJ2.ClauseE clauseE, int maxCard, int maxCount, boolean[][] xorLeft, boolean[] xorRight) {
        if (!this.matching.subsumption(this.matching.createClauseC(query), clauseE).booleanValue()) {
            return new HashSet<Set<Term>>();
        }
        SubsumptionEngineJ2.ClauseC queryC = this.matching.createClauseC(query);
        if (!this.matching.getEngine().solveWithResumer(queryC, clauseE, 2).booleanValue()) {
            return new HashSet<Set<Term>>();
        }
        Term[] termOrder = this.matching.getEngine().lastVariableOrder(queryC);
        ArrayList<Variable> variableList = new ArrayList<Variable>();
        for (int i = 0; i < termOrder.length; ++i) {
            if (!(termOrder[i] instanceof Variable)) continue;
            variableList.add((Variable)termOrder[i]);
        }
        HashSet<Set<Term>> partial = new HashSet<Set<Term>>();
        partial.add(new HashSet());
        block1: for (int i = 0; i < variableList.size(); ++i) {
            HashSet newPartial = new HashSet();
            for (Set set : partial) {
                ArrayList<Literal> extendedLits = new ArrayList<Literal>();
                extendedLits.addAll(query.literals());
                for (int j = 0; j < i; ++j) {
                    Literal newLit = new Literal("@in", set.size() + 1);
                    newLit.set((Term)variableList.get(j), 0);
                    int k = 1;
                    for (Term t : set) {
                        newLit.set(t, k);
                        ++k;
                    }
                    extendedLits.add(newLit);
                }
                Clause extendedQuery = new Clause(extendedLits);
                SubsumptionEngineJ2.ClauseC clauseC = this.matching.createClauseC(extendedQuery);
                if (xorLeft != null && xorRight != null) {
                    this.addXorConstraints(clauseC, maxCard, xorLeft, xorRight);
                }
                Pair<Term[], List<Term[]>> sol = this.matching.getEngine().allSolutions(clauseC, clauseE, maxCount, 1, (Term)variableList.get(i));
                for (Term[] ts : (List)sol.s) {
                    Term term = ts[0];
                    if (this.matching.getEngine().subsumptionMode() != 1 && set.contains(term)) continue;
                    Set extendedSet = Sugar.setFromCollections(set);
                    extendedSet.add(term);
                    if (extendedSet.size() > maxCard) continue;
                    newPartial.add(extendedSet);
                }
                double thresh = Math.pow(2.0, maxCard) * (double)maxCount + 1.0;
                if ((double)newPartial.size() > thresh) {
                    HashSet<Set> temp = new HashSet<Set>();
                    for (Set set2 : newPartial) {
                        temp.add(set2);
                        if (!((double)temp.size() >= thresh)) continue;
                        break;
                    }
                    partial = temp;
                    continue block1;
                }
                partial = newPartial;
            }
        }
        return partial;
    }

    private void addXorConstraints(SubsumptionEngineJ2.ClauseC clauseC, int maxCard, boolean[][] leftHand, boolean[] rightHand) {
        MaxCardXorConstraint constr = new MaxCardXorConstraint(maxCard, clauseC.numActualConstants(), this.clauseE.allTerms(), leftHand, rightHand, clauseC);
        clauseC.addGlobalConstraint(constr);
    }

    private static Clause randomGraph(int n, int m) {
        HashSet<Literal> l = new HashSet<Literal>();
        ArrayList<Constant> vs = new ArrayList<Constant>();
        for (int i = 0; i < n; ++i) {
            vs.add(Constant.construct(String.valueOf(i)));
        }
        Random random = new Random(1L);
        for (int i = 0; i < m; ++i) {
            l.add(new Literal("a", (Term)vs.get(random.nextInt(n)), (Term)vs.get(random.nextInt(n))));
        }
        return new Clause(l);
    }

    public void setSubsumptionMode(int subsumptionMode) {
        this.matching.setSubsumptionMode(subsumptionMode);
    }

    public static void main(String[] args) {
        Clause a = Clause.parse("@alldiff(A,B,C,D,E),a(A,B),a(A,C),a(A,D),a(B,C),a(C,D),a(D,C),a(D,E),a(E,A)");
        Clause c = Clause.parse("@alldiff(A,B,C,D,E), a(A,B), a(B,A)");
        Clause b = ApproximateSubsetCounter.randomGraph(100, 4000);
        ApproximateSubsetCounter asm = new ApproximateSubsetCounter(b, 0.5, 3);
        long mm1 = System.currentTimeMillis();
        double logApproxCount = asm.logApproxCount(a, 5);
        long mm2 = System.currentTimeMillis();
        System.out.println("T: " + (mm2 - mm1) + "ms");
        System.out.println("Approximate size: " + Math.pow(2.0, logApproxCount));
        Matching m = new Matching();
        m.setArcConsistencyStartsIn(1);
        m.setSubsumptionMode(1);
        long m1 = System.currentTimeMillis();
        SubsumptionEngineJ2.countFC = 0;
        Pair<Term[], List<Term[]>> subs = m.allSubstitutions(a, b);
        long m2 = System.currentTimeMillis();
        System.out.println("T: " + (m2 - m1) + "ms, est: , fc: " + (double)(m2 - m1) / (double)SubsumptionEngineJ2.countFC + ", all groundings: " + ((List)subs.s).size());
        HashSet<Set<Term>> subsets0 = new HashSet<Set<Term>>();
        System.out.println(Sugar.objectArrayToString((Object[])subs.r));
        for (Term[] s : (List)subs.s) {
            subsets0.add(Sugar.set(s));
        }
        System.out.println("SUBSETS0.size(): " + subsets0.size());
        System.out.println("\nSUBSETS:");
        m1 = System.currentTimeMillis();
        System.out.println("subsumes? " + m.subsumption(a, b));
    }
}

