/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.computation.iteration.modes;

import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.neural.networks.computation.iteration.BottomUp;
import cz.cvut.fel.ida.neural.networks.computation.iteration.NeuronIterating;
import cz.cvut.fel.ida.neural.networks.computation.iteration.NeuronVisiting;
import cz.cvut.fel.ida.neural.networks.computation.iteration.TopDown;
import cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.neurons.NeuronVisitor;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.BaseNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.WeightedNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import cz.cvut.fel.ida.neural.networks.structure.components.types.TopologicNetwork;
import java.util.logging.Logger;

public class Topologic {
    private static final Logger LOG = Logger.getLogger(Topologic.class.getName());
    TopologicNetwork<State.Structure> network;

    public Topologic(TopologicNetwork<State.Structure> network) {
        this.network = network;
    }

    public class BUpIterator
    extends NeuronIterating
    implements BottomUp<Value> {
        int i;

        public BUpIterator(Neurons outputNeuron, NeuronVisitor.Weighted pureNeuronVisitor) {
            super(Topologic.this.network, outputNeuron, pureNeuronVisitor);
            this.i = 0;
        }

        @Override
        public BaseNeuron<Neurons, State.Neural> next() {
            return Topologic.this.network.allNeuronsTopologic.get(this.i++);
        }

        @Override
        public boolean hasNext() {
            if (this.i == 0) {
                return true;
            }
            return this.i < Topologic.this.network.allNeuronsTopologic.size() && Topologic.this.network.allNeuronsTopologic.get(this.i - 1) != this.outputNeuron;
        }

        @Override
        public Value bottomUp() {
            this.iterate();
            return this.outputNeuron.getComputationView(this.neuronVisitor.stateVisitor.stateIndex).getValue();
        }
    }

    public class TDownIterator
    extends NeuronIterating
    implements TopDown {
        int i;

        public TDownIterator(BaseNeuron outputNeuron, NeuronVisitor.Weighted pureNeuronVisitor) {
            super(Topologic.this.network, outputNeuron, pureNeuronVisitor);
            this.i = Topologic.this.network.allNeuronsTopologic.size() - 1;
            while (Topologic.this.network.allNeuronsTopologic.get(this.i) != outputNeuron) {
                --this.i;
            }
        }

        @Override
        public BaseNeuron<Neurons, State.Neural> next() {
            return Topologic.this.network.allNeuronsTopologic.get(this.i--);
        }

        @Override
        public boolean hasNext() {
            return this.i >= 0;
        }

        @Override
        public void topdown() {
            this.iterate();
        }
    }

    public class BUpVisitor
    extends NeuronVisiting.Weighted
    implements BottomUp<Value> {
        NeuronVisitor.Weighted neuronVisitor;

        public BUpVisitor(Neurons outputNeuron, NeuronVisitor.Weighted pureNeuronVisitor) {
            super(Topologic.this.network, outputNeuron);
            this.neuronVisitor = pureNeuronVisitor;
        }

        @Override
        public Value bottomUp() {
            int i = 0;
            int len = Topologic.this.network.allNeuronsTopologic.size();
            while (i < len) {
                BaseNeuron<Neurons, State.Neural> actualNeuron = Topologic.this.network.allNeuronsTopologic.get(i);
                int index = actualNeuron.index;
                actualNeuron.index = i++;
                actualNeuron.visit(this.neuronVisitor);
                actualNeuron.index = index;
                if (actualNeuron == this.outputNeuron) break;
            }
            return this.outputNeuron.getComputationView(this.neuronVisitor.stateVisitor.stateIndex).getValue();
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(BaseNeuron<T, S> neuron) {
            ((NeuronVisitor)this.neuronVisitor).visit(neuron);
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(WeightedNeuron<T, S> neuron) {
            this.neuronVisitor.visit(neuron);
        }
    }

    public class TDownVisitor
    extends NeuronVisiting.Weighted
    implements TopDown {
        NeuronVisitor.Weighted neuronVisitor;

        public TDownVisitor(Neurons outputNeuron, NeuronVisitor.Weighted pureNeuronVisitor) {
            super(Topologic.this.network, outputNeuron);
            this.neuronVisitor = pureNeuronVisitor;
        }

        @Override
        public void topdown() {
            int idx = Topologic.this.network.allNeuronsTopologic.size() - 1;
            while (Topologic.this.network.allNeuronsTopologic.get(idx) != this.outputNeuron) {
                --idx;
            }
            while (idx > 0) {
                BaseNeuron<Neurons, State.Neural> actualNeuron = Topologic.this.network.allNeuronsTopologic.get(idx);
                int index = actualNeuron.index;
                actualNeuron.index = idx--;
                actualNeuron.visit(this.neuronVisitor);
                actualNeuron.index = index;
            }
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(BaseNeuron<T, S> neuron) {
            ((NeuronVisitor)this.neuronVisitor).visit(neuron);
        }

        @Override
        public <T extends Neurons, S extends State.Neural> void visit(WeightedNeuron<T, S> neuron) {
            this.neuronVisitor.visit(neuron);
        }
    }
}

