/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines;

import cz.cvut.fel.ida.pipelines.Block;
import cz.cvut.fel.ida.pipelines.ConnectAfter;
import cz.cvut.fel.ida.pipelines.ConnectBefore;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.setup.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class Merge<I1, I2, O>
extends Block
implements ConnectAfter<O> {
    private static final Logger LOG = Logger.getLogger(Merge.class.getName());
    public Pipe<I1, I1> input1;
    public Pipe<I2, I2> input2;
    public ConnectBefore<O> output;
    O outputReady;

    public Merge(String id, Settings settings) {
        super(id, settings);
        this.input1 = new Pipe<I1, I1>(id + "-Input1"){

            @Override
            public I1 apply(I1 i1) throws Exception {
                this.outputReady = i1;
                Merge.this.accept(i1);
                return i1;
            }
        };
        this.input2 = new Pipe<I2, I2>(id + "-Input2"){

            @Override
            public I2 apply(I2 i2) throws Exception {
                this.outputReady = i2;
                Merge.this.accept(i2);
                return i2;
            }
        };
    }

    @Override
    public O get() throws Exception {
        if (this.outputReady == null) {
            String err = "The result of this Merge " + this.ID + " is requested but not yet calculated (backtracking in the execution graph).";
            LOG.severe(err);
            throw new Exception(err);
        }
        return this.outputReady;
    }

    public void accept(Object o) throws Exception {
        I2 i2;
        I1 i1 = this.input1.get();
        if (i1 != null && (i2 = this.input2.get()) != null) {
            LOG.finer("Entering: " + this.ID);
            this.accept(i1, i2);
        } else {
            LOG.finer("Backtracking: " + this.ID);
        }
    }

    public void accept(I1 input1, I2 input2) throws Exception {
        this.outputReady = this.merge(input1, input2);
        super.export(this.outputReady);
        if (this.output != null) {
            this.output.accept(this.outputReady);
        }
    }

    protected abstract O merge(I1 var1, I2 var2);

    @Override
    public ConnectBefore<O> getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(ConnectBefore<O> prev) {
        this.output = prev;
    }

    public ConnectAfter<I1> connectBeforeL(ConnectAfter<I1> prev) {
        return this.input1.connectBefore(prev);
    }

    public ConnectAfter<I2> connectBeforeR(ConnectAfter<I2> prev) {
        return this.input2.connectBefore(prev);
    }

    public List<Merge<I1, I2, O>> parallel(int count) {
        ArrayList<Merge<I1, I2, O>> copies = new ArrayList<Merge<I1, I2, O>>(count);
        for (int i = 0; i < count; ++i) {
            copies.add(new Merge<I1, I2, O>(this.ID + i, this.settings){

                @Override
                protected O merge(I1 input1, I2 input2) {
                    return Merge.this.merge(input1, input2);
                }
            });
        }
        return copies;
    }

    public static <T, A extends Merge<T, ?, ?>, B extends ConnectAfter<T>> void connectBeforeL(List<A> merges, List<B> pipes) {
        if (merges.size() != pipes.size()) {
            LOG.severe("The 2 Lists of merges and pipes provided cannot be connected with different sizes!");
        }
        for (int i = 0; i < merges.size(); ++i) {
            ((Merge)merges.get(i)).connectBeforeL((ConnectAfter)pipes.get(i));
        }
    }

    public static <T, A extends Merge<?, T, ?>, B extends ConnectAfter<T>> void connectBeforeR(List<A> merges, List<B> pipes) {
        if (merges.size() != pipes.size()) {
            LOG.severe("The 2 Lists of merges and pipes provided cannot be connected with different sizes!");
        }
        for (int i = 0; i < merges.size(); ++i) {
            ((Merge)merges.get(i)).connectBeforeR((ConnectAfter)pipes.get(i));
        }
    }

    public static <T, A extends Merge<?, ?, T>, B extends ConnectBefore<T>> void connectAfter(List<A> merges, List<B> pipes) {
        if (merges.size() != pipes.size()) {
            LOG.severe("The 2 Lists of merges and pipes provided cannot be connected with different sizes!");
        }
        for (int i = 0; i < merges.size(); ++i) {
            ((Merge)merges.get(i)).connectAfter((ConnectBefore)pipes.get(i));
        }
    }
}

