/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines;

import cz.cvut.fel.ida.pipelines.Block;
import cz.cvut.fel.ida.pipelines.ConnectAfter;
import cz.cvut.fel.ida.pipelines.ConnectBefore;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.setup.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;

public abstract class MultiMerge<I, O>
extends Block
implements ConnectAfter<O> {
    private static final Logger LOG = Logger.getLogger(MultiMerge.class.getName());
    public List<Pipe<I, I>> inputs;
    public ConnectBefore<O> output;
    private ConcurrentLinkedQueue<I> inputsReady;
    public O outputReady;

    protected MultiMerge(String id, int count, Settings settings) {
        this.settings = settings;
        this.ID = id;
        this.inputs = new ArrayList<Pipe<I, I>>(count);
        for (int i = 0; i < count; ++i) {
            this.inputs.add(new Pipe<I, I>(id + "Input" + i){

                @Override
                public I apply(I i) throws Exception {
                    MultiMerge.this.accept(i);
                    return i;
                }
            });
        }
        this.inputsReady = new ConcurrentLinkedQueue();
    }

    private void accept(I i) throws Exception {
        this.inputsReady.add(i);
        if (this.inputsReady.size() == this.inputs.size()) {
            LOG.finer("Entering: " + this.ID);
            this.accept((List<I>)new ArrayList<I>(this.inputsReady));
        }
    }

    @Override
    public O get() throws Exception {
        if (this.outputReady == null) {
            String err = "The result of this MultiMerge " + this.ID + " is requested but not yet calculated";
            LOG.severe(err);
            LOG.severe("Pipeline is broken");
            throw new Exception(err);
        }
        return this.outputReady;
    }

    public void accept(List<I> allInputs) throws Exception {
        this.outputReady = this.merge(allInputs);
        if (this.output != null) {
            this.output.accept(this.outputReady);
        }
    }

    protected abstract O merge(List<I> var1);

    @Override
    public ConnectBefore<O> getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(ConnectBefore<O> prev) {
        this.output = prev;
    }

    public <T extends ConnectAfter<I>> List<T> connectBefore(List<T> prev) {
        if (prev.size() != this.inputs.size()) {
            LOG.severe("MultiMerge input dimension mismatches with preceding providers!");
        }
        for (int i = 0; i < this.inputs.size(); ++i) {
            this.inputs.get(i).connectBefore((ConnectAfter)prev.get(i));
        }
        return prev;
    }
}

