/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.building;

import cz.cvut.fel.ida.learning.crossvalidation.MeanStdResults;
import cz.cvut.fel.ida.learning.crossvalidation.TrainTestResults;
import cz.cvut.fel.ida.learning.results.Progress;
import cz.cvut.fel.ida.learning.results.Results;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralModel;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.pipelines.building.CrossvalidationBuilder;
import cz.cvut.fel.ida.pipelines.building.End2endTrainigBuilder;
import cz.cvut.fel.ida.pipelines.building.TestingBuilder;
import cz.cvut.fel.ida.pipelines.building.TrainTestBuilder;
import cz.cvut.fel.ida.pipelines.building.TrainingBuilder;
import cz.cvut.fel.ida.pipelines.bulding.AbstractPipelineBuilder;
import cz.cvut.fel.ida.pipelines.debugging.GroundingDebugger;
import cz.cvut.fel.ida.pipelines.debugging.NeuralDebugger;
import cz.cvut.fel.ida.pipelines.debugging.TemplateDebugger;
import cz.cvut.fel.ida.pipelines.debugging.TrainingDebugger;
import cz.cvut.fel.ida.pipelines.debuging.drawing.PipelineDebugger;
import cz.cvut.fel.ida.pipelines.pipes.generic.SecondFromPairPipe;
import cz.cvut.fel.ida.pipelines.pipes.specific.ResultsFromProgressPipe;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.setup.Sources;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.logging.Logger;

public class LearningSchemeBuilder
extends AbstractPipelineBuilder<Sources, Results> {
    private static final Logger LOG = Logger.getLogger(LearningSchemeBuilder.class.getName());
    private Sources sources;

    public LearningSchemeBuilder(Settings settings, Sources sources) {
        super(settings);
        this.sources = sources;
    }

    public static Pipeline<Sources, ?> getPipeline(Settings settings, Sources sources) {
        LOG.finest("Building pipeline from sources and settings...");
        AbstractPipelineBuilder<Sources, ?> pipelineBuilder = LearningSchemeBuilder.getBuilder(sources, settings);
        Pipeline<Sources, ?> pipeline = pipelineBuilder.buildPipeline();
        if (settings.debugPipeline) {
            new PipelineDebugger(settings).debug(pipeline);
        }
        LOG.finest("The main pipeline has been built");
        return pipeline;
    }

    public static AbstractPipelineBuilder<Sources, ?> getBuilder(Sources sources, Settings settings) {
        if (settings.mainMode == Settings.MainMode.COMPLETE) {
            return new LearningSchemeBuilder(settings, sources);
        }
        if (settings.mainMode == Settings.MainMode.DEBUGGING) {
            if (settings.debugTemplateTraining || settings.debugSampleTraining) {
                return new TrainingDebugger(sources, settings);
            }
            if (settings.debugNeuralization) {
                return new NeuralDebugger(sources, settings);
            }
            if (settings.debugGrounding) {
                return new GroundingDebugger(sources, settings);
            }
            if (settings.debugTemplate) {
                return new TemplateDebugger(sources, settings);
            }
        } else if (settings.mainMode == Settings.MainMode.NEURALIZATION) {
            return new End2endTrainigBuilder.End2endNNBuilder(new End2endTrainigBuilder(settings, sources));
        }
        LOG.severe("Unknown pipeline mainMode!");
        throw new UnsupportedOperationException();
    }

    @Override
    public Pipeline<Sources, Results> buildPipeline() {
        return this.buildPipeline(this.sources);
    }

    public Pipeline<Sources, Results> buildPipeline(Sources sources) {
        Pipeline<Sources, Results> pipeline = new Pipeline<Sources, Results>("LearningSchemePipeline", this);
        LOG.finer("------------------------------------------WORKFLOW SETUP-------------------------------------------------------");
        if (sources.crossvalidation) {
            LOG.fine("Learning scheme inferred as : ---CROSSVALIDATION---");
            CrossvalidationBuilder crossvalidationSchemeBuilder = new CrossvalidationBuilder(this.settings, sources);
            Pipeline<Sources, Pair<MeanStdResults.TrainValTest, TrainTestResults>> crossvalPipeline = pipeline.registerStart(crossvalidationSchemeBuilder.buildPipeline());
            Pipe pipe = crossvalPipeline.connectAfter(pipeline.register(new SecondFromPairPipe()));
            pipe.connectAfter(pipeline.registerEnd(this.getTestResultsPipe()));
        } else if (sources.trainTest) {
            LOG.fine("Learning scheme inferred as : ---TRAIN-TEST---");
            TrainTestBuilder trainTestBuilder = new TrainTestBuilder(this.settings, sources);
            Pipeline<Sources, TrainTestResults> trainTestPipeline = pipeline.registerStart(trainTestBuilder.buildPipeline());
            trainTestPipeline.connectAfter(pipeline.registerEnd(this.getTestResultsPipe()));
        } else if (sources.trainOnly) {
            LOG.fine("Learning scheme inferred as : ---TRAINING ONLY---");
            Pipeline<Sources, Pair<Pair<Template, NeuralModel>, Progress>> trainingPipeline = pipeline.registerStart(new TrainingBuilder(this.settings, sources).buildPipeline());
            SecondFromPairPipe secondFromPairPipe = pipeline.register(new SecondFromPairPipe());
            trainingPipeline.connectAfter(secondFromPairPipe);
            ResultsFromProgressPipe resultsFromProgressPipe = pipeline.registerEnd(new ResultsFromProgressPipe());
            secondFromPairPipe.connectAfter(resultsFromProgressPipe);
        } else if (sources.testOnly) {
            LOG.fine("Learning scheme inferred as : ---TESTING ONLY---");
            Pipeline<Sources, Results> pipeline2 = pipeline.registerEnd(pipeline.registerStart(new TestingBuilder(this.settings, sources).buildPipeline()));
        } else {
            LOG.severe("Invalid learning mode setting.");
        }
        return pipeline;
    }

    Pipe<TrainTestResults, Results> getTestResultsPipe() {
        return new Pipe<TrainTestResults, Results>("GetTestResultsPipe"){

            @Override
            public Results apply(TrainTestResults trainTestResults) {
                return trainTestResults.testing;
            }
        };
    }
}

