/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.building;

import cz.cvut.fel.ida.learning.LearningSample;
import cz.cvut.fel.ida.logic.constructs.example.LogicSample;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.pipelines.Merge;
import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.pipelines.building.SamplesProcessingBuilder;
import cz.cvut.fel.ida.pipelines.building.TemplateProcessingBuilder;
import cz.cvut.fel.ida.pipelines.bulding.AbstractPipelineBuilder;
import cz.cvut.fel.ida.pipelines.pipes.generic.DuplicateBranch;
import cz.cvut.fel.ida.pipelines.pipes.generic.LambdaPipe;
import cz.cvut.fel.ida.pipelines.pipes.generic.PairMerge;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.setup.Source;
import cz.cvut.fel.ida.setup.Sources;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class TemplateSamplesBuilder
extends AbstractPipelineBuilder<Sources, Pair<Template, Stream<LogicSample>>> {
    private static final Logger LOG = Logger.getLogger(TemplateSamplesBuilder.class.getName());
    private Sources sources;

    public TemplateSamplesBuilder(Sources sources, Settings settings) {
        super(settings);
        this.sources = sources;
    }

    @Override
    public Pipeline<Sources, Pair<Template, Stream<LogicSample>>> buildPipeline() {
        Pipeline<Sources, Pair<Template, Stream<LogicSample>>> pipeline = new Pipeline<Sources, Pair<Template, Stream<LogicSample>>>("buildFromSourcesPipeline", this.settings);
        LambdaPipe<Sources, Source> getSource = null;
        SamplesProcessingBuilder samplesProcessor = null;
        if (this.sources.trainOnly || this.sources.trainTest) {
            getSource = pipeline.register(new LambdaPipe<Sources, Source>("getTrainSourcePipe", sources -> sources.train, this.settings));
            samplesProcessor = new SamplesProcessingBuilder(this.settings, this.sources.train);
        } else if (this.sources.testOnly) {
            getSource = pipeline.register(new LambdaPipe<Sources, Source>("getTestSourcePipe", sources -> sources.test, this.settings));
            samplesProcessor = new SamplesProcessingBuilder(this.settings, this.sources.test);
        } else {
            LOG.severe("Unrecognized train/test mode");
            throw new UnsupportedOperationException();
        }
        Pipeline<Source, Stream<LogicSample>> getLogicSampleStream = pipeline.register(samplesProcessor.buildPipeline());
        getSource.connectAfter(getLogicSampleStream);
        DuplicateBranch duplicateBranch = pipeline.registerStart(new DuplicateBranch("DuplicateSourcesBranch"));
        Pipeline<Sources, Template> sourcesTemplatePipeline = pipeline.register(this.getSourcesTemplatePipeline(this.sources, this.settings));
        PairMerge pairMerge = pipeline.registerEnd(new PairMerge("TemplateSamplesMerge"));
        duplicateBranch.connectAfterR(sourcesTemplatePipeline);
        pairMerge.connectBeforeL(sourcesTemplatePipeline);
        if (this.sources.val != null && (this.sources.val.QueriesProvided || this.sources.val.ExamplesProvided)) {
            DuplicateBranch trainValSamplesBranch = pipeline.register(new DuplicateBranch("TrainValSamplesBranch"));
            duplicateBranch.connectAfterL(trainValSamplesBranch);
            trainValSamplesBranch.connectAfterL(getSource);
            LambdaPipe<Sources, Source> getVal = pipeline.register(new LambdaPipe<Sources, Source>("getValSourcePipe", sources -> sources.val, this.settings));
            SamplesProcessingBuilder valSamplesProcessor = new SamplesProcessingBuilder(this.settings, this.sources.val);
            Pipeline<Source, Stream<LogicSample>> getValSampleStream = pipeline.register(valSamplesProcessor.buildPipeline());
            getVal.connectAfter(getValSampleStream);
            trainValSamplesBranch.connectAfterR(getVal);
            1 trainValMerge = pipeline.register(new Merge<Stream<LogicSample>, Stream<LogicSample>, Stream<LogicSample>>("trainValMerge", this.settings){

                @Override
                protected Stream<LogicSample> merge(Stream<LogicSample> train, Stream<LogicSample> val) {
                    Stream<LogicSample> valStream = val.map(sample -> {
                        sample.type = LearningSample.Split.VALIDATION;
                        return sample;
                    });
                    return Stream.concat(train, valStream);
                }
            });
            trainValMerge.connectBeforeL(getLogicSampleStream);
            trainValMerge.connectBeforeR(getValSampleStream);
            pairMerge.connectBeforeR(trainValMerge);
        } else {
            duplicateBranch.connectAfterL(getSource);
            pairMerge.connectBeforeR(getLogicSampleStream);
        }
        return pipeline;
    }

    public Pipeline<Sources, Template> getSourcesTemplatePipeline(Sources sources, Settings settings) {
        TemplateProcessingBuilder templateProcessor = new TemplateProcessingBuilder(settings, sources);
        return templateProcessor.buildPipeline();
    }
}

