/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.building;

import cz.cvut.fel.ida.learning.crossvalidation.TrainTestResults;
import cz.cvut.fel.ida.learning.results.Progress;
import cz.cvut.fel.ida.learning.results.Results;
import cz.cvut.fel.ida.logic.constructs.example.LogicSample;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralModel;
import cz.cvut.fel.ida.neural.networks.computation.training.NeuralSample;
import cz.cvut.fel.ida.pipelines.Merge;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.pipelines.building.SamplesProcessingBuilder;
import cz.cvut.fel.ida.pipelines.building.TestingBuilder;
import cz.cvut.fel.ida.pipelines.building.TrainingBuilder;
import cz.cvut.fel.ida.pipelines.bulding.AbstractPipelineBuilder;
import cz.cvut.fel.ida.pipelines.pipes.generic.DuplicateBranch;
import cz.cvut.fel.ida.pipelines.pipes.generic.PairBranch;
import cz.cvut.fel.ida.pipelines.pipes.generic.PairMerge;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.setup.Source;
import cz.cvut.fel.ida.setup.Sources;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class TrainTestBuilder
extends AbstractPipelineBuilder<Sources, TrainTestResults> {
    private static final Logger LOG = Logger.getLogger(TrainTestBuilder.class.getName());
    private final Sources sources;
    Merge<Progress, Results, TrainTestResults> resultsMerge;
    int counter = 0;

    public TrainTestBuilder(Settings settings, Sources sources) {
        super(settings);
        this.sources = sources;
        this.resultsMerge = new Merge<Progress, Results, TrainTestResults>("TrainTestResultsMerge", settings){

            @Override
            protected TrainTestResults merge(Progress train, Results test) {
                return new TrainTestResults(train, test);
            }
        };
    }

    @Override
    public Pipeline<Sources, TrainTestResults> buildPipeline() {
        if (this.sources.folds != null) {
            return this.buildPipeline(this.sources.folds.get(this.counter++));
        }
        return this.buildPipeline(this.sources);
    }

    public Pipeline<Sources, TrainTestResults> buildPipeline(Sources sources) {
        Pipeline<Sources, TrainTestResults> pipeline = new Pipeline<Sources, TrainTestResults>("TrainTestPipeline", this);
        DuplicateBranch duplicateSources = pipeline.registerStart(new DuplicateBranch());
        2 testExtrPipe = pipeline.register(new Pipe<Sources, Source>("TestExtractionPipe"){

            @Override
            public Source apply(Sources sources) {
                return sources.test;
            }
        });
        TrainingBuilder trainingBuilder = new TrainingBuilder(this.settings, sources);
        TestingBuilder testingBuilder = new TestingBuilder(this.settings, sources);
        Pipeline<Sources, Pair<Pair<Template, NeuralModel>, Progress>> trainingPipeline = pipeline.register(trainingBuilder.buildPipeline());
        PairBranch pairBranch1 = pipeline.register(new PairBranch());
        TestingBuilder testingBuilder2 = testingBuilder;
        testingBuilder2.getClass();
        Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> logicTestingPipeline = pipeline.register(new TestingBuilder.LogicTestingBuilder(testingBuilder2, this.settings).buildPipeline());
        Pipeline<Source, Stream<LogicSample>> testSamplesStreamPipeline = pipeline.register(new SamplesProcessingBuilder(this.settings, sources.test).buildPipeline(sources.test));
        PairMerge pairMerge = pipeline.register(new PairMerge());
        duplicateSources.connectAfterL(testExtrPipe);
        duplicateSources.connectAfterR(trainingPipeline);
        testExtrPipe.connectAfter(testSamplesStreamPipeline);
        trainingPipeline.connectAfter(pairBranch1);
        pairMerge.connectBeforeL(pairBranch1.output1);
        pairMerge.connectBeforeR(testSamplesStreamPipeline);
        pairMerge.connectAfter(logicTestingPipeline);
        this.resultsMerge.connectBeforeL(pairBranch1.output2);
        this.resultsMerge.connectBeforeR(logicTestingPipeline);
        pipeline.registerEnd(this.resultsMerge);
        return pipeline;
    }

    public class NeuralTrainTestBuilder
    extends AbstractPipelineBuilder<Pair<NeuralModel, Pair<Stream<NeuralSample>, Stream<NeuralSample>>>, TrainTestResults> {
        public NeuralTrainTestBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Pair<NeuralModel, Pair<Stream<NeuralSample>, Stream<NeuralSample>>>, TrainTestResults> buildPipeline() {
            Pipeline<Pair<NeuralModel, Pair<Stream<NeuralSample>, Stream<NeuralSample>>>, TrainTestResults> pipeline = new Pipeline<Pair<NeuralModel, Pair<Stream<NeuralSample>, Stream<NeuralSample>>>, TrainTestResults>("NeuralTrainTestPipeline", this);
            TrainingBuilder.NeuralLearningBuilder neuralLearningBuilder = new TrainingBuilder.NeuralLearningBuilder(this.settings);
            Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Pair<NeuralModel, Progress>> neuralLearning = pipeline.register(neuralLearningBuilder.buildPipeline());
            TestingBuilder testingBuilder = new TestingBuilder(this.settings, TrainTestBuilder.this.sources);
            testingBuilder.getClass();
            TestingBuilder.NeuralTestingBuilder neuralTestingBuilder = new TestingBuilder.NeuralTestingBuilder(testingBuilder, this.settings);
            Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Results> neuralTesting = pipeline.register(neuralTestingBuilder.buildPipeline());
            PairBranch modelSamplesBranch = pipeline.registerStart(new PairBranch());
            PairBranch trainTestBranch = pipeline.register(new PairBranch());
            PairBranch modelResultsBranch = pipeline.register(new PairBranch());
            PairMerge trainingMerge = pipeline.register(new PairMerge());
            PairMerge testingMerge = pipeline.register(new PairMerge());
            pipeline.registerStart(modelSamplesBranch);
            modelSamplesBranch.connectAfterL(trainingMerge.input1);
            modelSamplesBranch.connectAfterR(trainTestBranch);
            trainingMerge.connectBeforeR(trainTestBranch.output1);
            trainingMerge.connectAfter(neuralLearning);
            neuralLearning.connectAfter(modelResultsBranch);
            testingMerge.connectBeforeL(modelResultsBranch.output1);
            testingMerge.connectBeforeR(trainTestBranch.output2);
            testingMerge.connectAfter(neuralTesting);
            TrainTestBuilder.this.resultsMerge.connectBeforeL(modelResultsBranch.output2);
            TrainTestBuilder.this.resultsMerge.connectBeforeR(neuralTesting);
            pipeline.registerEnd(TrainTestBuilder.this.resultsMerge);
            return pipeline;
        }
    }

    public class StructureTrainTestBuilder
    extends AbstractPipelineBuilder<Pair<Stream<LogicSample>, Stream<LogicSample>>, TrainTestResults> {
        public StructureTrainTestBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Pair<Stream<LogicSample>, Stream<LogicSample>>, TrainTestResults> buildPipeline() {
            TestingBuilder testingBuilder;
            Pipeline<Pair<Stream<LogicSample>, Stream<LogicSample>>, TrainTestResults> pipeline = new Pipeline<Pair<Stream<LogicSample>, Stream<LogicSample>>, TrainTestResults>("StructureTrainTestPipeline", this);
            PairBranch trainTestBranch = pipeline.registerStart(new PairBranch());
            Pipeline<Stream<LogicSample>, Pair<Pair<Template, NeuralModel>, Progress>> trainingPipeline = pipeline.register(new TrainingBuilder.StructureLearningBuilder(this.settings).buildPipeline());
            TestingBuilder testingBuilder2 = testingBuilder = new TestingBuilder(this.settings, TrainTestBuilder.this.sources);
            testingBuilder2.getClass();
            Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> testingPipeline = pipeline.register(new TestingBuilder.LogicTestingBuilder(testingBuilder2, this.settings).buildPipeline());
            PairBranch trainResultsBranch = pipeline.register(new PairBranch());
            PairMerge testMerge = pipeline.register(new PairMerge());
            trainTestBranch.connectAfterL(trainingPipeline);
            trainingPipeline.connectAfter(trainResultsBranch);
            testMerge.connectBeforeL(trainResultsBranch.output1);
            testMerge.connectBeforeR(trainTestBranch.output2);
            testMerge.connectAfter(testingPipeline);
            TrainTestBuilder.this.resultsMerge.connectBeforeL(trainResultsBranch.output2);
            TrainTestBuilder.this.resultsMerge.connectBeforeR(testingPipeline);
            pipeline.registerEnd(TrainTestBuilder.this.resultsMerge);
            return pipeline;
        }
    }

    public class LogicTrainTestBuilder
    extends AbstractPipelineBuilder<Pair<Template, Pair<Stream<LogicSample>, Stream<LogicSample>>>, TrainTestResults> {
        public LogicTrainTestBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Pair<Template, Pair<Stream<LogicSample>, Stream<LogicSample>>>, TrainTestResults> buildPipeline() {
            Pipeline<Pair<Template, Pair<Stream<LogicSample>, Stream<LogicSample>>>, TrainTestResults> pipeline = new Pipeline<Pair<Template, Pair<Stream<LogicSample>, Stream<LogicSample>>>, TrainTestResults>("LogicTrainTestPipeline", this);
            PairBranch templateSamplesBranch = pipeline.registerStart(new PairBranch());
            PairBranch trainTestBranch = pipeline.register(new PairBranch());
            PairMerge trainMerge = pipeline.register(new PairMerge());
            PairMerge testMerge = pipeline.register(new PairMerge());
            PairBranch trainResultsBranch = pipeline.register(new PairBranch());
            TrainingBuilder trainingBuilder = new TrainingBuilder(this.settings, TrainTestBuilder.this.sources);
            TestingBuilder testingBuilder = new TestingBuilder(this.settings, TrainTestBuilder.this.sources);
            TrainingBuilder trainingBuilder2 = trainingBuilder;
            trainingBuilder2.getClass();
            Pipeline<Pair<Template, Stream<LogicSample>>, Pair<Pair<Template, NeuralModel>, Progress>> trainingPipeline = pipeline.register(new TrainingBuilder.LogicLearningBuilder(trainingBuilder2, this.settings).buildPipeline());
            TestingBuilder testingBuilder2 = testingBuilder;
            testingBuilder2.getClass();
            Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> testingPipeline = pipeline.register(new TestingBuilder.LogicTestingBuilder(testingBuilder2, this.settings).buildPipeline());
            templateSamplesBranch.connectAfterR(trainTestBranch);
            trainMerge.connectBeforeL(templateSamplesBranch.output1);
            trainMerge.connectBeforeR(trainTestBranch.output1);
            trainMerge.connectAfter(trainingPipeline);
            trainingPipeline.connectAfter(trainResultsBranch);
            testMerge.connectBeforeL(trainResultsBranch.output1);
            testMerge.connectBeforeR(trainTestBranch.output2);
            testMerge.connectAfter(testingPipeline);
            TrainTestBuilder.this.resultsMerge.connectBeforeL(trainResultsBranch.output2);
            TrainTestBuilder.this.resultsMerge.connectBeforeR(testingPipeline);
            pipeline.registerEnd(TrainTestBuilder.this.resultsMerge);
            return pipeline;
        }
    }
}

